@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Custom method for BrokerAuthentication
 * @property auth Custom Broker Authentication Method.
 * @property caCertConfigMap CA cert config map to use.
 * @property endpoint Endpoint to connect to.
 * @property headers Configuration Headers to use.
 */
public data class BrokerAuthenticatorMethodCustomResponse(
    public val auth: BrokerAuthenticatorCustomAuthResponse? = null,
    public val caCertConfigMap: String? = null,
    public val endpoint: String,
    public val headers: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BrokerAuthenticatorMethodCustomResponse):
            BrokerAuthenticatorMethodCustomResponse = BrokerAuthenticatorMethodCustomResponse(
            auth = javaType.auth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorCustomAuthResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            caCertConfigMap = javaType.caCertConfigMap().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            headers = javaType.headers().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
