@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ExtendedLocation properties
 * @property name The name of the extended location.
 * @property type Type of ExtendedLocation.
 */
public data class ExtendedLocationPropertyResponse(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.ExtendedLocationPropertyResponse):
            ExtendedLocationPropertyResponse = ExtendedLocationPropertyResponse(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
