@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Kafka RemoteBrokerConnection TLS details
 * @property tlsEnabled Tls Enabled on Remote Broker Connection.
 * @property trustedCaCertificateConfigMap Trusted CA certificate name for Remote Broker.
 */
public data class KafkaRemoteBrokerConnectionTlsResponse(
    public val tlsEnabled: Boolean,
    public val trustedCaCertificateConfigMap: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaRemoteBrokerConnectionTlsResponse):
            KafkaRemoteBrokerConnectionTlsResponse = KafkaRemoteBrokerConnectionTlsResponse(
            tlsEnabled = javaType.tlsEnabled(),
            trustedCaCertificateConfigMap = javaType.trustedCaCertificateConfigMap().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
