@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * Kafka Routes properties. NOTE - Enum only one method is allowed to be passed.
 * @property kafkaToMqtt Kafka to Mqtt route.
 * @property mqttToKafka Mqtt to Kafka route.
 */
public data class KafkaRoutesResponse(
    public val kafkaToMqtt: KafkaToMqttRoutesResponse? = null,
    public val mqttToKafka: MqttToKafkaRoutesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaRoutesResponse):
            KafkaRoutesResponse = KafkaRoutesResponse(
            kafkaToMqtt = javaType.kafkaToMqtt().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaToMqttRoutesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mqttToKafka = javaType.mqttToKafka().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttToKafkaRoutesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
