@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Kafka Token KeyVault properties.
 * @property username Username to connect with.
 * @property vault KeyVault properties.
 * @property vaultSecret KeyVault secret details.
 */
public data class KafkaTokenKeyVaultPropertiesResponse(
    public val username: String? = null,
    public val vault: KeyVaultConnectionPropertiesResponse,
    public val vaultSecret: KeyVaultSecretObjectResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaTokenKeyVaultPropertiesResponse):
            KafkaTokenKeyVaultPropertiesResponse = KafkaTokenKeyVaultPropertiesResponse(
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
            vault = javaType.vault().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            vaultSecret = javaType.vaultSecret().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultSecretObjectResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
