@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Kafka RemoteBrokerConnection X509 Authentication properties.
 * @property keyVault Keyvault X509 secret properties.
 * @property secretName Secret where cert details are stored.
 */
public data class KafkaX509AuthenticationResponse(
    public val keyVault: KeyVaultCertificatePropertiesResponse? = null,
    public val secretName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaX509AuthenticationResponse):
            KafkaX509AuthenticationResponse = KafkaX509AuthenticationResponse(
            keyVault = javaType.keyVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultCertificatePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secretName = javaType.secretName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
