@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * KeyVault properties
 * @property credentials KeyVault credentials.
 * @property directoryId KeyVault directoryId.
 * @property name KeyVault name.
 */
public data class KeyVaultConnectionPropertiesResponse(
    public val credentials: KeyVaultCredentialsPropertiesResponse,
    public val directoryId: String,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KeyVaultConnectionPropertiesResponse):
            KeyVaultConnectionPropertiesResponse = KeyVaultConnectionPropertiesResponse(
            credentials = javaType.credentials().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultCredentialsPropertiesResponse.Companion.toKotlin(args0)
            }),
            directoryId = javaType.directoryId(),
            name = javaType.name(),
        )
    }
}
