@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * MqttBridge RemoteBroker X509 Authentication properties.
 * @property keyVault Keyvault X509 secret properties.
 * @property secretName Secret where cert details are stored.
 */
public data class MqttBridgeRemoteBrokerX509AuthenticationResponse(
    public val keyVault: KeyVaultCertificatePropertiesResponse? = null,
    public val secretName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.MqttBridgeRemoteBrokerX509AuthenticationResponse):
            MqttBridgeRemoteBrokerX509AuthenticationResponse =
            MqttBridgeRemoteBrokerX509AuthenticationResponse(
                keyVault = javaType.keyVault().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultCertificatePropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                secretName = javaType.secretName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
