@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the Node Tolerations details
 * @property effect Toleration effect.
 * @property key Toleration key.
 * @property operator Toleration operator like 'Exists', 'Equal' etc.
 * @property value Toleration Value.
 */
public data class NodeTolerationsResponse(
    public val effect: String,
    public val key: String,
    public val `operator`: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.NodeTolerationsResponse):
            NodeTolerationsResponse = NodeTolerationsResponse(
            effect = javaType.effect(),
            key = javaType.key(),
            `operator` = javaType.`operator`(),
            `value` = javaType.`value`(),
        )
    }
}
