@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * VolumeClaimResourceRequirements properties
 * @property limits Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
 * @property requests Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
 */
public data class VolumeClaimResourceRequirementsResponse(
    public val limits: Map<String, String>? = null,
    public val requests: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.VolumeClaimResourceRequirementsResponse):
            VolumeClaimResourceRequirementsResponse = VolumeClaimResourceRequirementsResponse(
            limits = javaType.limits().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            requests = javaType.requests().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
