@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMPrivateEndpointResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMPrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.ManagedHsmSkuResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMPrivateEndpointResponse.Companion.toKotlin as mHSMPrivateEndpointResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMPrivateLinkServiceConnectionStateResponse.Companion.toKotlin as mHSMPrivateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.ManagedHsmSkuResponse.Companion.toKotlin as managedHsmSkuResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MHSMPrivateEndpointConnection].
 */
@PulumiTagMarker
public class MHSMPrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MHSMPrivateEndpointConnectionArgs = MHSMPrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MHSMPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = MHSMPrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MHSMPrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MHSMPrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * Private endpoint connection resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### ManagedHsmPutPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mhsmPrivateEndpointConnection = new AzureNative.KeyVault.MHSMPrivateEndpointConnection("mhsmPrivateEndpointConnection", new()
 *     {
 *         Name = "sample-mhsm",
 *         PrivateEndpointConnectionName = "sample-pec",
 *         PrivateLinkServiceConnectionState = new AzureNative.KeyVault.Inputs.MHSMPrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "My name is Joe and I'm approving this.",
 *             Status = AzureNative.KeyVault.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "sample-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewMHSMPrivateEndpointConnection(ctx, "mhsmPrivateEndpointConnection", &keyvault.MHSMPrivateEndpointConnectionArgs{
 * 			Name:                          pulumi.String("sample-mhsm"),
 * 			PrivateEndpointConnectionName: pulumi.String("sample-pec"),
 * 			PrivateLinkServiceConnectionState: &keyvault.MHSMPrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("My name is Joe and I'm approving this."),
 * 				Status:      pulumi.String(keyvault.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnection;
 * import com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.keyvault.inputs.MHSMPrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mhsmPrivateEndpointConnection = new MHSMPrivateEndpointConnection("mhsmPrivateEndpointConnection", MHSMPrivateEndpointConnectionArgs.builder()
 *             .name("sample-mhsm")
 *             .privateEndpointConnectionName("sample-pec")
 *             .privateLinkServiceConnectionState(MHSMPrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("My name is Joe and I'm approving this.")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("sample-group")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:MHSMPrivateEndpointConnection sample-pec /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class MHSMPrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnection,
) : KotlinCustomResource(javaResource, MHSMPrivateEndpointConnectionMapper) {
    /**
     * Modified whenever there is a change in the state of private endpoint connection.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The supported Azure location where the managed HSM Pool should be created.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the managed HSM Pool.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the private endpoint object.
     */
    public val privateEndpoint: Output<MHSMPrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> mHSMPrivateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Approval state of the private link connection.
     */
    public val privateLinkServiceConnectionState:
        Output<MHSMPrivateLinkServiceConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mHSMPrivateLinkServiceConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the private endpoint connection.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * SKU details
     */
    public val sku: Output<ManagedHsmSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedHsmSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the key vault resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type of the managed HSM Pool.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MHSMPrivateEndpointConnectionMapper : ResourceMapper<MHSMPrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): MHSMPrivateEndpointConnection =
        MHSMPrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnection,
        )
}

/**
 * @see [MHSMPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MHSMPrivateEndpointConnection].
 */
public suspend fun mhsmPrivateEndpointConnection(
    name: String,
    block: suspend MHSMPrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    MHSMPrivateEndpointConnection {
    val builder = MHSMPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MHSMPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mhsmPrivateEndpointConnection(name: String): MHSMPrivateEndpointConnection {
    val builder = MHSMPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
