@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.inputs.MHSMPrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.MHSMPrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.azurenative.keyvault.kotlin.inputs.ManagedHsmSkuArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.ManagedHsmSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Private endpoint connection resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### ManagedHsmPutPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mhsmPrivateEndpointConnection = new AzureNative.KeyVault.MHSMPrivateEndpointConnection("mhsmPrivateEndpointConnection", new()
 *     {
 *         Name = "sample-mhsm",
 *         PrivateEndpointConnectionName = "sample-pec",
 *         PrivateLinkServiceConnectionState = new AzureNative.KeyVault.Inputs.MHSMPrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "My name is Joe and I'm approving this.",
 *             Status = AzureNative.KeyVault.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "sample-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewMHSMPrivateEndpointConnection(ctx, "mhsmPrivateEndpointConnection", &keyvault.MHSMPrivateEndpointConnectionArgs{
 * 			Name:                          pulumi.String("sample-mhsm"),
 * 			PrivateEndpointConnectionName: pulumi.String("sample-pec"),
 * 			PrivateLinkServiceConnectionState: &keyvault.MHSMPrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("My name is Joe and I'm approving this."),
 * 				Status:      pulumi.String(keyvault.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnection;
 * import com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.keyvault.inputs.MHSMPrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mhsmPrivateEndpointConnection = new MHSMPrivateEndpointConnection("mhsmPrivateEndpointConnection", MHSMPrivateEndpointConnectionArgs.builder()
 *             .name("sample-mhsm")
 *             .privateEndpointConnectionName("sample-pec")
 *             .privateLinkServiceConnectionState(MHSMPrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("My name is Joe and I'm approving this.")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("sample-group")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:MHSMPrivateEndpointConnection sample-pec /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property location The supported Azure location where the managed HSM Pool should be created.
 * @property name Name of the managed HSM Pool
 * @property privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm pool.
 * @property privateLinkServiceConnectionState Approval state of the private link connection.
 * @property resourceGroupName Name of the resource group that contains the managed HSM pool.
 * @property sku SKU details
 * @property tags Resource tags
 */
public data class MHSMPrivateEndpointConnectionArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<MHSMPrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ManagedHsmSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnectionArgs =
        com.pulumi.azurenative.keyvault.MHSMPrivateEndpointConnectionArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MHSMPrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class MHSMPrivateEndpointConnectionArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<MHSMPrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ManagedHsmSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The supported Azure location where the managed HSM Pool should be created.
     */
    @JvmName("uwdtodpetfxmmhso")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the managed HSM Pool
     */
    @JvmName("ffojcjmkvywtbgbv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the private endpoint connection associated with the managed hsm pool.
     */
    @JvmName("wgohtiqtassjyoon")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Approval state of the private link connection.
     */
    @JvmName("hrtqrwutnhadulxe")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<MHSMPrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Name of the resource group that contains the managed HSM pool.
     */
    @JvmName("mqvbtwrvlmbhyplo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU details
     */
    @JvmName("iiubwsfmgefnggfc")
    public suspend fun sku(`value`: Output<ManagedHsmSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("svtmvqcuyoxmtvvd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The supported Azure location where the managed HSM Pool should be created.
     */
    @JvmName("mcdtjnalqslbdnhd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the managed HSM Pool
     */
    @JvmName("usyoqdmqxcsvtrua")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the private endpoint connection associated with the managed hsm pool.
     */
    @JvmName("vkwsjicxhbmdioqm")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Approval state of the private link connection.
     */
    @JvmName("pxigeqkxkminxsit")
    public suspend
    fun privateLinkServiceConnectionState(`value`: MHSMPrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Approval state of the private link connection.
     */
    @JvmName("vowfkbmngvcwhevy")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend MHSMPrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = MHSMPrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Name of the resource group that contains the managed HSM pool.
     */
    @JvmName("xqiyeoogyxlfffxv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU details
     */
    @JvmName("wnlmgiqqwrbypgdg")
    public suspend fun sku(`value`: ManagedHsmSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU details
     */
    @JvmName("hhndnkifxdpvxdyu")
    public suspend fun sku(argument: suspend ManagedHsmSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedHsmSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ounecftmoyowcuff")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("xirwdctblrxxeiso")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MHSMPrivateEndpointConnectionArgs = MHSMPrivateEndpointConnectionArgs(
        location = location,
        name = name,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
