@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.VaultPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.VaultPropertiesResponse.Companion.toKotlin as vaultPropertiesResponseToKotlin

/**
 * Builder for [Vault].
 */
@PulumiTagMarker
public class VaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultArgs = VaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultArgsBuilder.() -> Unit) {
        val builder = VaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Vault {
        val builtJavaResource = com.pulumi.azurenative.keyvault.Vault(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vault(builtJavaResource)
    }
}

/**
 * Resource information with extended details.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2018-02-14-preview, 2023-07-01.
 * ## Example Usage
 * ### Create a new vault or update an existing vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.KeyVault.Vault("vault", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.KeyVault.Inputs.VaultPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.KeyVault.Inputs.AccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "00000000-0000-0000-0000-000000000000",
 *                     Permissions = new AzureNative.KeyVault.Inputs.PermissionsArgs
 *                     {
 *                         Certificates = new[]
 *                         {
 *                             AzureNative.KeyVault.CertificatePermissions.@Get,
 *                             AzureNative.KeyVault.CertificatePermissions.List,
 *                             AzureNative.KeyVault.CertificatePermissions.Delete,
 *                             AzureNative.KeyVault.CertificatePermissions.Create,
 *                             AzureNative.KeyVault.CertificatePermissions.Import,
 *                             AzureNative.KeyVault.CertificatePermissions.Update,
 *                             AzureNative.KeyVault.CertificatePermissions.Managecontacts,
 *                             AzureNative.KeyVault.CertificatePermissions.Getissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Listissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Setissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Deleteissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Manageissuers,
 *                             AzureNative.KeyVault.CertificatePermissions.Recover,
 *                             AzureNative.KeyVault.CertificatePermissions.Purge,
 *                         },
 *                         Keys = new[]
 *                         {
 *                             AzureNative.KeyVault.KeyPermissions.Encrypt,
 *                             AzureNative.KeyVault.KeyPermissions.Decrypt,
 *                             AzureNative.KeyVault.KeyPermissions.WrapKey,
 *                             AzureNative.KeyVault.KeyPermissions.UnwrapKey,
 *                             AzureNative.KeyVault.KeyPermissions.Sign,
 *                             AzureNative.KeyVault.KeyPermissions.Verify,
 *                             AzureNative.KeyVault.KeyPermissions.@Get,
 *                             AzureNative.KeyVault.KeyPermissions.List,
 *                             AzureNative.KeyVault.KeyPermissions.Create,
 *                             AzureNative.KeyVault.KeyPermissions.Update,
 *                             AzureNative.KeyVault.KeyPermissions.Import,
 *                             AzureNative.KeyVault.KeyPermissions.Delete,
 *                             AzureNative.KeyVault.KeyPermissions.Backup,
 *                             AzureNative.KeyVault.KeyPermissions.Restore,
 *                             AzureNative.KeyVault.KeyPermissions.Recover,
 *                             AzureNative.KeyVault.KeyPermissions.Purge,
 *                         },
 *                         Secrets = new[]
 *                         {
 *                             AzureNative.KeyVault.SecretPermissions.@Get,
 *                             AzureNative.KeyVault.SecretPermissions.List,
 *                             AzureNative.KeyVault.SecretPermissions.@Set,
 *                             AzureNative.KeyVault.SecretPermissions.Delete,
 *                             AzureNative.KeyVault.SecretPermissions.Backup,
 *                             AzureNative.KeyVault.SecretPermissions.Restore,
 *                             AzureNative.KeyVault.SecretPermissions.Recover,
 *                             AzureNative.KeyVault.SecretPermissions.Purge,
 *                         },
 *                     },
 *                     TenantId = "00000000-0000-0000-0000-000000000000",
 *                 },
 *             },
 *             EnabledForDeployment = true,
 *             EnabledForDiskEncryption = true,
 *             EnabledForTemplateDeployment = true,
 *             PublicNetworkAccess = "Enabled",
 *             Sku = new AzureNative.KeyVault.Inputs.SkuArgs
 *             {
 *                 Family = AzureNative.KeyVault.SkuFamily.A,
 *                 Name = AzureNative.KeyVault.SkuName.Standard,
 *             },
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "sample-resource-group",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewVault(ctx, "vault", &keyvault.VaultArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: &keyvault.VaultPropertiesArgs{
 * 				AccessPolicies: keyvault.AccessPolicyEntryArray{
 * 					&keyvault.AccessPolicyEntryArgs{
 * 						ObjectId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 						Permissions: &keyvault.PermissionsArgs{
 * 							Certificates: pulumi.StringArray{
 * 								pulumi.String(keyvault.CertificatePermissionsGet),
 * 								pulumi.String(keyvault.CertificatePermissionsList),
 * 								pulumi.String(keyvault.CertificatePermissionsDelete),
 * 								pulumi.String(keyvault.CertificatePermissionsCreate),
 * 								pulumi.String(keyvault.CertificatePermissionsImport),
 * 								pulumi.String(keyvault.CertificatePermissionsUpdate),
 * 								pulumi.String(keyvault.CertificatePermissionsManagecontacts),
 * 								pulumi.String(keyvault.CertificatePermissionsGetissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsListissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsSetissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsDeleteissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsManageissuers),
 * 								pulumi.String(keyvault.CertificatePermissionsRecover),
 * 								pulumi.String(keyvault.CertificatePermissionsPurge),
 * 							},
 * 							Keys: pulumi.StringArray{
 * 								pulumi.String(keyvault.KeyPermissionsEncrypt),
 * 								pulumi.String(keyvault.KeyPermissionsDecrypt),
 * 								pulumi.String(keyvault.KeyPermissionsWrapKey),
 * 								pulumi.String(keyvault.KeyPermissionsUnwrapKey),
 * 								pulumi.String(keyvault.KeyPermissionsSign),
 * 								pulumi.String(keyvault.KeyPermissionsVerify),
 * 								pulumi.String(keyvault.KeyPermissionsGet),
 * 								pulumi.String(keyvault.KeyPermissionsList),
 * 								pulumi.String(keyvault.KeyPermissionsCreate),
 * 								pulumi.String(keyvault.KeyPermissionsUpdate),
 * 								pulumi.String(keyvault.KeyPermissionsImport),
 * 								pulumi.String(keyvault.KeyPermissionsDelete),
 * 								pulumi.String(keyvault.KeyPermissionsBackup),
 * 								pulumi.String(keyvault.KeyPermissionsRestore),
 * 								pulumi.String(keyvault.KeyPermissionsRecover),
 * 								pulumi.String(keyvault.KeyPermissionsPurge),
 * 							},
 * 							Secrets: pulumi.StringArray{
 * 								pulumi.String(keyvault.SecretPermissionsGet),
 * 								pulumi.String(keyvault.SecretPermissionsList),
 * 								pulumi.String(keyvault.SecretPermissionsSet),
 * 								pulumi.String(keyvault.SecretPermissionsDelete),
 * 								pulumi.String(keyvault.SecretPermissionsBackup),
 * 								pulumi.String(keyvault.SecretPermissionsRestore),
 * 								pulumi.String(keyvault.SecretPermissionsRecover),
 * 								pulumi.String(keyvault.SecretPermissionsPurge),
 * 							},
 * 						},
 * 						TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 					},
 * 				},
 * 				EnabledForDeployment:         pulumi.Bool(true),
 * 				EnabledForDiskEncryption:     pulumi.Bool(true),
 * 				EnabledForTemplateDeployment: pulumi.Bool(true),
 * 				PublicNetworkAccess:          pulumi.String("Enabled"),
 * 				Sku: &keyvault.SkuArgs{
 * 					Family: pulumi.String(keyvault.SkuFamilyA),
 * 					Name:   keyvault.SkuNameStandard,
 * 				},
 * 				TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-resource-group"),
 * 			VaultName:         pulumi.String("sample-vault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Vault;
 * import com.pulumi.azurenative.keyvault.VaultArgs;
 * import com.pulumi.azurenative.keyvault.inputs.VaultPropertiesArgs;
 * import com.pulumi.azurenative.keyvault.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("westus")
 *             .properties(VaultPropertiesArgs.builder()
 *                 .accessPolicies(AccessPolicyEntryArgs.builder()
 *                     .objectId("00000000-0000-0000-0000-000000000000")
 *                     .permissions(PermissionsArgs.builder()
 *                         .certificates(
 *                             "get",
 *                             "list",
 *                             "delete",
 *                             "create",
 *                             "import",
 *                             "update",
 *                             "managecontacts",
 *                             "getissuers",
 *                             "listissuers",
 *                             "setissuers",
 *                             "deleteissuers",
 *                             "manageissuers",
 *                             "recover",
 *                             "purge")
 *                         .keys(
 *                             "encrypt",
 *                             "decrypt",
 *                             "wrapKey",
 *                             "unwrapKey",
 *                             "sign",
 *                             "verify",
 *                             "get",
 *                             "list",
 *                             "create",
 *                             "update",
 *                             "import",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge")
 *                         .secrets(
 *                             "get",
 *                             "list",
 *                             "set",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge")
 *                         .build())
 *                     .tenantId("00000000-0000-0000-0000-000000000000")
 *                     .build())
 *                 .enabledForDeployment(true)
 *                 .enabledForDiskEncryption(true)
 *                 .enabledForTemplateDeployment(true)
 *                 .publicNetworkAccess("Enabled")
 *                 .sku(SkuArgs.builder()
 *                     .family("A")
 *                     .name("standard")
 *                     .build())
 *                 .tenantId("00000000-0000-0000-0000-000000000000")
 *                 .build())
 *             .resourceGroupName("sample-resource-group")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a vault with network acls
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.KeyVault.Vault("vault", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.KeyVault.Inputs.VaultPropertiesArgs
 *         {
 *             EnabledForDeployment = true,
 *             EnabledForDiskEncryption = true,
 *             EnabledForTemplateDeployment = true,
 *             NetworkAcls = new AzureNative.KeyVault.Inputs.NetworkRuleSetArgs
 *             {
 *                 Bypass = AzureNative.KeyVault.NetworkRuleBypassOptions.AzureServices,
 *                 DefaultAction = AzureNative.KeyVault.NetworkRuleAction.Deny,
 *                 IpRules = new[]
 *                 {
 *                     new AzureNative.KeyVault.Inputs.IPRuleArgs
 *                     {
 *                         Value = "124.56.78.91",
 *                     },
 *                     new AzureNative.KeyVault.Inputs.IPRuleArgs
 *                     {
 *                         Value = "'10.91.4.0/24'",
 *                     },
 *                 },
 *                 VirtualNetworkRules = new[]
 *                 {
 *                     new AzureNative.KeyVault.Inputs.VirtualNetworkRuleArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1",
 *                     },
 *                 },
 *             },
 *             Sku = new AzureNative.KeyVault.Inputs.SkuArgs
 *             {
 *                 Family = AzureNative.KeyVault.SkuFamily.A,
 *                 Name = AzureNative.KeyVault.SkuName.Standard,
 *             },
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "sample-resource-group",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewVault(ctx, "vault", &keyvault.VaultArgs{
 * 			Location: pulumi.String("westus"),
 * 			Properties: &keyvault.VaultPropertiesArgs{
 * 				EnabledForDeployment:         pulumi.Bool(true),
 * 				EnabledForDiskEncryption:     pulumi.Bool(true),
 * 				EnabledForTemplateDeployment: pulumi.Bool(true),
 * 				NetworkAcls: &keyvault.NetworkRuleSetArgs{
 * 					Bypass:        pulumi.String(keyvault.NetworkRuleBypassOptionsAzureServices),
 * 					DefaultAction: pulumi.String(keyvault.NetworkRuleActionDeny),
 * 					IpRules: keyvault.IPRuleArray{
 * 						&keyvault.IPRuleArgs{
 * 							Value: pulumi.String("124.56.78.91"),
 * 						},
 * 						&keyvault.IPRuleArgs{
 * 							Value: pulumi.String("'10.91.4.0/24'"),
 * 						},
 * 					},
 * 					VirtualNetworkRules: keyvault.VirtualNetworkRuleArray{
 * 						&keyvault.VirtualNetworkRuleArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1"),
 * 						},
 * 					},
 * 				},
 * 				Sku: &keyvault.SkuArgs{
 * 					Family: pulumi.String(keyvault.SkuFamilyA),
 * 					Name:   keyvault.SkuNameStandard,
 * 				},
 * 				TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-resource-group"),
 * 			VaultName:         pulumi.String("sample-vault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Vault;
 * import com.pulumi.azurenative.keyvault.VaultArgs;
 * import com.pulumi.azurenative.keyvault.inputs.VaultPropertiesArgs;
 * import com.pulumi.azurenative.keyvault.inputs.NetworkRuleSetArgs;
 * import com.pulumi.azurenative.keyvault.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("westus")
 *             .properties(VaultPropertiesArgs.builder()
 *                 .enabledForDeployment(true)
 *                 .enabledForDiskEncryption(true)
 *                 .enabledForTemplateDeployment(true)
 *                 .networkAcls(NetworkRuleSetArgs.builder()
 *                     .bypass("AzureServices")
 *                     .defaultAction("Deny")
 *                     .ipRules(
 *                         IPRuleArgs.builder()
 *                             .value("124.56.78.91")
 *                             .build(),
 *                         IPRuleArgs.builder()
 *                             .value("'10.91.4.0/24'")
 *                             .build())
 *                     .virtualNetworkRules(VirtualNetworkRuleArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1")
 *                         .build())
 *                     .build())
 *                 .sku(SkuArgs.builder()
 *                     .family("A")
 *                     .name("standard")
 *                     .build())
 *                 .tenantId("00000000-0000-0000-0000-000000000000")
 *                 .build())
 *             .resourceGroupName("sample-resource-group")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:Vault sample-vault /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
 * ```
 */
public class Vault internal constructor(
    override val javaResource: com.pulumi.azurenative.keyvault.Vault,
) : KotlinCustomResource(javaResource, VaultMapper) {
    /**
     * Azure location of the key vault resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the key vault resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the vault
     */
    public val properties: Output<VaultPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                vaultPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * System metadata for the key vault.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags assigned to the key vault resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type of the key vault resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VaultMapper : ResourceMapper<Vault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.keyvault.Vault::class == javaResource::class

    override fun map(javaResource: Resource): Vault = Vault(
        javaResource as
            com.pulumi.azurenative.keyvault.Vault,
    )
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vault].
 */
public suspend fun vault(name: String, block: suspend VaultResourceBuilder.() -> Unit): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vault(name: String): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
