@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.AccessPolicyEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An identity that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
 * @property applicationId  Application ID of the client making request on behalf of a principal
 * @property objectId The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
 * @property permissions Permissions the identity has for keys, secrets and certificates.
 * @property tenantId The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
 */
public data class AccessPolicyEntryArgs(
    public val applicationId: Output<String>? = null,
    public val objectId: Output<String>,
    public val permissions: Output<PermissionsArgs>,
    public val tenantId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.AccessPolicyEntryArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.AccessPolicyEntryArgs =
        com.pulumi.azurenative.keyvault.inputs.AccessPolicyEntryArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .objectId(objectId.applyValue({ args0 -> args0 }))
            .permissions(permissions.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tenantId(tenantId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPolicyEntryArgs].
 */
@PulumiTagMarker
public class AccessPolicyEntryArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var objectId: Output<String>? = null

    private var permissions: Output<PermissionsArgs>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value  Application ID of the client making request on behalf of a principal
     */
    @JvmName("uutmtruugykuxuth")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
     */
    @JvmName("grchmpebqcfhecnd")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Permissions the identity has for keys, secrets and certificates.
     */
    @JvmName("ehwjjcfanhqgiple")
    public suspend fun permissions(`value`: Output<PermissionsArgs>) {
        this.permissions = value
    }

    /**
     * @param value The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
     */
    @JvmName("boambngbrytpboag")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value  Application ID of the client making request on behalf of a principal
     */
    @JvmName("xrcoilcjkpqfxyuq")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
     */
    @JvmName("acowaqmfflskrdvw")
    public suspend fun objectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value Permissions the identity has for keys, secrets and certificates.
     */
    @JvmName("grjxjatlqnllnhlo")
    public suspend fun permissions(`value`: PermissionsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument Permissions the identity has for keys, secrets and certificates.
     */
    @JvmName("yhjiqrpmlkkhpqct")
    public suspend fun permissions(argument: suspend PermissionsArgsBuilder.() -> Unit) {
        val toBeMapped = PermissionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param value The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
     */
    @JvmName("vseqsffkxoinrxrm")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AccessPolicyEntryArgs = AccessPolicyEntryArgs(
        applicationId = applicationId,
        objectId = objectId ?: throw PulumiNullFieldException("objectId"),
        permissions = permissions ?: throw PulumiNullFieldException("permissions"),
        tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
    )
}
