@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.KeyAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The object attributes managed by the Azure Key Vault service.
 * @property enabled Determines whether or not the object is enabled.
 * @property expires Expiry date in seconds since 1970-01-01T00:00:00Z.
 * @property exportable Indicates if the private key can be exported.
 * @property notBefore Not before date in seconds since 1970-01-01T00:00:00Z.
 */
public data class KeyAttributesArgs(
    public val enabled: Output<Boolean>? = null,
    public val expires: Output<Double>? = null,
    public val exportable: Output<Boolean>? = null,
    public val notBefore: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.KeyAttributesArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.KeyAttributesArgs =
        com.pulumi.azurenative.keyvault.inputs.KeyAttributesArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .expires(expires?.applyValue({ args0 -> args0 }))
            .exportable(exportable?.applyValue({ args0 -> args0 }))
            .notBefore(notBefore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyAttributesArgs].
 */
@PulumiTagMarker
public class KeyAttributesArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var expires: Output<Double>? = null

    private var exportable: Output<Boolean>? = null

    private var notBefore: Output<Double>? = null

    /**
     * @param value Determines whether or not the object is enabled.
     */
    @JvmName("ysfkcrplkefbdepp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Expiry date in seconds since 1970-01-01T00:00:00Z.
     */
    @JvmName("pofoafqvrxumuxop")
    public suspend fun expires(`value`: Output<Double>) {
        this.expires = value
    }

    /**
     * @param value Indicates if the private key can be exported.
     */
    @JvmName("yqmmjvbclmgccjjd")
    public suspend fun exportable(`value`: Output<Boolean>) {
        this.exportable = value
    }

    /**
     * @param value Not before date in seconds since 1970-01-01T00:00:00Z.
     */
    @JvmName("ifqystmlnyyadrxg")
    public suspend fun notBefore(`value`: Output<Double>) {
        this.notBefore = value
    }

    /**
     * @param value Determines whether or not the object is enabled.
     */
    @JvmName("kyaxgchanbrjfjbx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Expiry date in seconds since 1970-01-01T00:00:00Z.
     */
    @JvmName("subumpptlivshyxo")
    public suspend fun expires(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expires = mapped
    }

    /**
     * @param value Indicates if the private key can be exported.
     */
    @JvmName("fmaqpcqhlcitehni")
    public suspend fun exportable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportable = mapped
    }

    /**
     * @param value Not before date in seconds since 1970-01-01T00:00:00Z.
     */
    @JvmName("evvmnfcyshbndwbm")
    public suspend fun notBefore(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notBefore = mapped
    }

    internal fun build(): KeyAttributesArgs = KeyAttributesArgs(
        enabled = enabled,
        expires = expires,
        exportable = exportable,
        notBefore = notBefore,
    )
}
