@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.ManagedHsmPropertiesArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.CreateMode
import com.pulumi.azurenative.keyvault.kotlin.enums.PublicNetworkAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of the managed HSM Pool
 * @property createMode The create mode to indicate whether the resource is being created or is being recovered from a deleted resource.
 * @property enablePurgeProtection Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. Enabling this functionality is irreversible.
 * @property enableSoftDelete Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and is immutable.
 * @property initialAdminObjectIds Array of initial administrators object ids for this managed hsm pool.
 * @property networkAcls Rules governing the accessibility of the key vault from specific network locations.
 * @property publicNetworkAccess Control permission to the managed HSM from public networks.
 * @property regions List of all regions associated with the managed hsm pool.
 * @property softDeleteRetentionInDays Soft deleted data retention days. When you delete an HSM or a key, it will remain recoverable for the configured retention period or for a default period of 90 days. It accepts values between 7 and 90.
 * @property tenantId The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
 */
public data class ManagedHsmPropertiesArgs(
    public val createMode: Output<CreateMode>? = null,
    public val enablePurgeProtection: Output<Boolean>? = null,
    public val enableSoftDelete: Output<Boolean>? = null,
    public val initialAdminObjectIds: Output<List<String>>? = null,
    public val networkAcls: Output<MHSMNetworkRuleSetArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val regions: Output<List<MHSMGeoReplicatedRegionArgs>>? = null,
    public val softDeleteRetentionInDays: Output<Int>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.ManagedHsmPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.ManagedHsmPropertiesArgs =
        com.pulumi.azurenative.keyvault.inputs.ManagedHsmPropertiesArgs.builder()
            .createMode(createMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enablePurgeProtection(enablePurgeProtection?.applyValue({ args0 -> args0 }))
            .enableSoftDelete(enableSoftDelete?.applyValue({ args0 -> args0 }))
            .initialAdminObjectIds(initialAdminObjectIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkAcls(networkAcls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .regions(
                regions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .softDeleteRetentionInDays(softDeleteRetentionInDays?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedHsmPropertiesArgs].
 */
@PulumiTagMarker
public class ManagedHsmPropertiesArgsBuilder internal constructor() {
    private var createMode: Output<CreateMode>? = null

    private var enablePurgeProtection: Output<Boolean>? = null

    private var enableSoftDelete: Output<Boolean>? = null

    private var initialAdminObjectIds: Output<List<String>>? = null

    private var networkAcls: Output<MHSMNetworkRuleSetArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var regions: Output<List<MHSMGeoReplicatedRegionArgs>>? = null

    private var softDeleteRetentionInDays: Output<Int>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The create mode to indicate whether the resource is being created or is being recovered from a deleted resource.
     */
    @JvmName("wrnijnfusbbivfrw")
    public suspend fun createMode(`value`: Output<CreateMode>) {
        this.createMode = value
    }

    /**
     * @param value Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. Enabling this functionality is irreversible.
     */
    @JvmName("fgvglweqyqgoyjpp")
    public suspend fun enablePurgeProtection(`value`: Output<Boolean>) {
        this.enablePurgeProtection = value
    }

    /**
     * @param value Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and is immutable.
     */
    @JvmName("eqlghjopgcydqmey")
    public suspend fun enableSoftDelete(`value`: Output<Boolean>) {
        this.enableSoftDelete = value
    }

    /**
     * @param value Array of initial administrators object ids for this managed hsm pool.
     */
    @JvmName("lowdnrcxytlwbksb")
    public suspend fun initialAdminObjectIds(`value`: Output<List<String>>) {
        this.initialAdminObjectIds = value
    }

    @JvmName("cmlkdrrmceeaenbf")
    public suspend fun initialAdminObjectIds(vararg values: Output<String>) {
        this.initialAdminObjectIds = Output.all(values.asList())
    }

    /**
     * @param values Array of initial administrators object ids for this managed hsm pool.
     */
    @JvmName("uttmivpsxwvhookh")
    public suspend fun initialAdminObjectIds(values: List<Output<String>>) {
        this.initialAdminObjectIds = Output.all(values)
    }

    /**
     * @param value Rules governing the accessibility of the key vault from specific network locations.
     */
    @JvmName("wupxhhfvfrjgyokl")
    public suspend fun networkAcls(`value`: Output<MHSMNetworkRuleSetArgs>) {
        this.networkAcls = value
    }

    /**
     * @param value Control permission to the managed HSM from public networks.
     */
    @JvmName("ymlrxwrslhwfutrj")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value List of all regions associated with the managed hsm pool.
     */
    @JvmName("rkguchbotwmscfhp")
    public suspend fun regions(`value`: Output<List<MHSMGeoReplicatedRegionArgs>>) {
        this.regions = value
    }

    @JvmName("fslxfeypwuwyvfns")
    public suspend fun regions(vararg values: Output<MHSMGeoReplicatedRegionArgs>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values List of all regions associated with the managed hsm pool.
     */
    @JvmName("cfqmgudgfmxaidis")
    public suspend fun regions(values: List<Output<MHSMGeoReplicatedRegionArgs>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value Soft deleted data retention days. When you delete an HSM or a key, it will remain recoverable for the configured retention period or for a default period of 90 days. It accepts values between 7 and 90.
     */
    @JvmName("qurvpurvwhovekna")
    public suspend fun softDeleteRetentionInDays(`value`: Output<Int>) {
        this.softDeleteRetentionInDays = value
    }

    /**
     * @param value The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
     */
    @JvmName("tewwqfvhvfalidbp")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The create mode to indicate whether the resource is being created or is being recovered from a deleted resource.
     */
    @JvmName("gdkcavlvqasbfpuc")
    public suspend fun createMode(`value`: CreateMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. Enabling this functionality is irreversible.
     */
    @JvmName("dhduxamgnknymxem")
    public suspend fun enablePurgeProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePurgeProtection = mapped
    }

    /**
     * @param value Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and is immutable.
     */
    @JvmName("oxubcnvcxthkqyix")
    public suspend fun enableSoftDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSoftDelete = mapped
    }

    /**
     * @param value Array of initial administrators object ids for this managed hsm pool.
     */
    @JvmName("hoqsnslaatndlqgq")
    public suspend fun initialAdminObjectIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialAdminObjectIds = mapped
    }

    /**
     * @param values Array of initial administrators object ids for this managed hsm pool.
     */
    @JvmName("pqhopoyotcgmgseo")
    public suspend fun initialAdminObjectIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialAdminObjectIds = mapped
    }

    /**
     * @param value Rules governing the accessibility of the key vault from specific network locations.
     */
    @JvmName("ifyrkqsodthclsqw")
    public suspend fun networkAcls(`value`: MHSMNetworkRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAcls = mapped
    }

    /**
     * @param argument Rules governing the accessibility of the key vault from specific network locations.
     */
    @JvmName("tsfcfunhgclwqigu")
    public suspend fun networkAcls(argument: suspend MHSMNetworkRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = MHSMNetworkRuleSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkAcls = mapped
    }

    /**
     * @param value Control permission to the managed HSM from public networks.
     */
    @JvmName("yhayqtaewmhqnyts")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Control permission to the managed HSM from public networks.
     */
    @JvmName("tjeywmkvjvyxkqtv")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Control permission to the managed HSM from public networks.
     */
    @JvmName("wxugvhyshtfotjli")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value List of all regions associated with the managed hsm pool.
     */
    @JvmName("pvnlxfnprbxjljde")
    public suspend fun regions(`value`: List<MHSMGeoReplicatedRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param argument List of all regions associated with the managed hsm pool.
     */
    @JvmName("dvjlwtiyujmjcbun")
    public suspend
    fun regions(argument: List<suspend MHSMGeoReplicatedRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MHSMGeoReplicatedRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument List of all regions associated with the managed hsm pool.
     */
    @JvmName("fnnqutreosijaxdj")
    public suspend fun regions(
        vararg
        argument: suspend MHSMGeoReplicatedRegionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MHSMGeoReplicatedRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument List of all regions associated with the managed hsm pool.
     */
    @JvmName("edruxwcdyhuxqmov")
    public suspend fun regions(argument: suspend MHSMGeoReplicatedRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MHSMGeoReplicatedRegionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param values List of all regions associated with the managed hsm pool.
     */
    @JvmName("rrjhvcoeffqfxoac")
    public suspend fun regions(vararg values: MHSMGeoReplicatedRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value Soft deleted data retention days. When you delete an HSM or a key, it will remain recoverable for the configured retention period or for a default period of 90 days. It accepts values between 7 and 90.
     */
    @JvmName("uuedcpmjjapaxcqd")
    public suspend fun softDeleteRetentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionInDays = mapped
    }

    /**
     * @param value The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
     */
    @JvmName("hidrxotbpmdxntpe")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ManagedHsmPropertiesArgs = ManagedHsmPropertiesArgs(
        createMode = createMode,
        enablePurgeProtection = enablePurgeProtection,
        enableSoftDelete = enableSoftDelete,
        initialAdminObjectIds = initialAdminObjectIds,
        networkAcls = networkAcls,
        publicNetworkAccess = publicNetworkAccess,
        regions = regions,
        softDeleteRetentionInDays = softDeleteRetentionInDays,
        tenantId = tenantId,
    )
}
