@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.SecretAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The secret management attributes.
 * @property enabled Determines whether the object is enabled.
 * @property expires Expiry date in seconds since 1970-01-01T00:00:00Z.
 * @property notBefore Not before date in seconds since 1970-01-01T00:00:00Z.
 */
public data class SecretAttributesArgs(
    public val enabled: Output<Boolean>? = null,
    public val expires: Output<Int>? = null,
    public val notBefore: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.SecretAttributesArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.SecretAttributesArgs =
        com.pulumi.azurenative.keyvault.inputs.SecretAttributesArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .expires(expires?.applyValue({ args0 -> args0 }))
            .notBefore(notBefore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretAttributesArgs].
 */
@PulumiTagMarker
public class SecretAttributesArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var expires: Output<Int>? = null

    private var notBefore: Output<Int>? = null

    /**
     * @param value Determines whether the object is enabled.
     */
    @JvmName("tgtcqoyteuyrxhdw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Expiry date in seconds since 1970-01-01T00:00:00Z.
     */
    @JvmName("ccstpniylnebipwt")
    public suspend fun expires(`value`: Output<Int>) {
        this.expires = value
    }

    /**
     * @param value Not before date in seconds since 1970-01-01T00:00:00Z.
     */
    @JvmName("snamjjbfresxrwvd")
    public suspend fun notBefore(`value`: Output<Int>) {
        this.notBefore = value
    }

    /**
     * @param value Determines whether the object is enabled.
     */
    @JvmName("kkjpwqfebfdgcbdp")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Expiry date in seconds since 1970-01-01T00:00:00Z.
     */
    @JvmName("wlglycbwwstxdxph")
    public suspend fun expires(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expires = mapped
    }

    /**
     * @param value Not before date in seconds since 1970-01-01T00:00:00Z.
     */
    @JvmName("foscsboloxheiwgi")
    public suspend fun notBefore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notBefore = mapped
    }

    internal fun build(): SecretAttributesArgs = SecretAttributesArgs(
        enabled = enabled,
        expires = expires,
        notBefore = notBefore,
    )
}
