@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.TriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property timeAfterCreate The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
 * @property timeBeforeExpiry The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
 */
public data class TriggerArgs(
    public val timeAfterCreate: Output<String>? = null,
    public val timeBeforeExpiry: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.TriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.TriggerArgs =
        com.pulumi.azurenative.keyvault.inputs.TriggerArgs.builder()
            .timeAfterCreate(timeAfterCreate?.applyValue({ args0 -> args0 }))
            .timeBeforeExpiry(timeBeforeExpiry?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerArgs].
 */
@PulumiTagMarker
public class TriggerArgsBuilder internal constructor() {
    private var timeAfterCreate: Output<String>? = null

    private var timeBeforeExpiry: Output<String>? = null

    /**
     * @param value The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
     */
    @JvmName("dlyumpftjhogofgd")
    public suspend fun timeAfterCreate(`value`: Output<String>) {
        this.timeAfterCreate = value
    }

    /**
     * @param value The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
     */
    @JvmName("fveoqdlckqtqlapr")
    public suspend fun timeBeforeExpiry(`value`: Output<String>) {
        this.timeBeforeExpiry = value
    }

    /**
     * @param value The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
     */
    @JvmName("jjsmxyihcjpxpvli")
    public suspend fun timeAfterCreate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeAfterCreate = mapped
    }

    /**
     * @param value The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
     */
    @JvmName("ijmexhlstfrwatua")
    public suspend fun timeBeforeExpiry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeBeforeExpiry = mapped
    }

    internal fun build(): TriggerArgs = TriggerArgs(
        timeAfterCreate = timeAfterCreate,
        timeBeforeExpiry = timeBeforeExpiry,
    )
}
