@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.VaultPropertiesArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.CreateMode
import com.pulumi.azurenative.keyvault.kotlin.enums.VaultProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of the vault
 * @property accessPolicies An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property createMode The vault's create mode to indicate whether the vault need to be recovered or not.
 * @property enablePurgeProtection Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
 * @property enableRbacAuthorization Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored. When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions are always authorized with RBAC.
 * @property enableSoftDelete Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true or false) when creating new key vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
 * @property enabledForDeployment Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
 * @property enabledForDiskEncryption Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
 * @property enabledForTemplateDeployment Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
 * @property networkAcls Rules governing the accessibility of the key vault from specific network locations.
 * @property provisioningState Provisioning state of the vault.
 * @property publicNetworkAccess Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except private endpoint traffic and that that originates from trusted services will be blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor the rules.
 * @property sku SKU details
 * @property softDeleteRetentionInDays softDelete data retention days. It accepts >=7 and <=90.
 * @property tenantId The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
 * @property vaultUri The URI of the vault for performing operations on keys and secrets.
 */
public data class VaultPropertiesArgs(
    public val accessPolicies: Output<List<AccessPolicyEntryArgs>>? = null,
    public val createMode: Output<CreateMode>? = null,
    public val enablePurgeProtection: Output<Boolean>? = null,
    public val enableRbacAuthorization: Output<Boolean>? = null,
    public val enableSoftDelete: Output<Boolean>? = null,
    public val enabledForDeployment: Output<Boolean>? = null,
    public val enabledForDiskEncryption: Output<Boolean>? = null,
    public val enabledForTemplateDeployment: Output<Boolean>? = null,
    public val networkAcls: Output<NetworkRuleSetArgs>? = null,
    public val provisioningState: Output<Either<String, VaultProvisioningState>>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val sku: Output<SkuArgs>,
    public val softDeleteRetentionInDays: Output<Int>? = null,
    public val tenantId: Output<String>,
    public val vaultUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.VaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.VaultPropertiesArgs =
        com.pulumi.azurenative.keyvault.inputs.VaultPropertiesArgs.builder()
            .accessPolicies(
                accessPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .createMode(createMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enablePurgeProtection(enablePurgeProtection?.applyValue({ args0 -> args0 }))
            .enableRbacAuthorization(enableRbacAuthorization?.applyValue({ args0 -> args0 }))
            .enableSoftDelete(enableSoftDelete?.applyValue({ args0 -> args0 }))
            .enabledForDeployment(enabledForDeployment?.applyValue({ args0 -> args0 }))
            .enabledForDiskEncryption(enabledForDiskEncryption?.applyValue({ args0 -> args0 }))
            .enabledForTemplateDeployment(enabledForTemplateDeployment?.applyValue({ args0 -> args0 }))
            .networkAcls(networkAcls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .sku(sku.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .softDeleteRetentionInDays(softDeleteRetentionInDays?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId.applyValue({ args0 -> args0 }))
            .vaultUri(vaultUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultPropertiesArgs].
 */
@PulumiTagMarker
public class VaultPropertiesArgsBuilder internal constructor() {
    private var accessPolicies: Output<List<AccessPolicyEntryArgs>>? = null

    private var createMode: Output<CreateMode>? = null

    private var enablePurgeProtection: Output<Boolean>? = null

    private var enableRbacAuthorization: Output<Boolean>? = null

    private var enableSoftDelete: Output<Boolean>? = null

    private var enabledForDeployment: Output<Boolean>? = null

    private var enabledForDiskEncryption: Output<Boolean>? = null

    private var enabledForTemplateDeployment: Output<Boolean>? = null

    private var networkAcls: Output<NetworkRuleSetArgs>? = null

    private var provisioningState: Output<Either<String, VaultProvisioningState>>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var softDeleteRetentionInDays: Output<Int>? = null

    private var tenantId: Output<String>? = null

    private var vaultUri: Output<String>? = null

    /**
     * @param value An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("kvxrmqslombqgpec")
    public suspend fun accessPolicies(`value`: Output<List<AccessPolicyEntryArgs>>) {
        this.accessPolicies = value
    }

    @JvmName("fvimpnsirudgrort")
    public suspend fun accessPolicies(vararg values: Output<AccessPolicyEntryArgs>) {
        this.accessPolicies = Output.all(values.asList())
    }

    /**
     * @param values An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("aflgdvxaxgfifafu")
    public suspend fun accessPolicies(values: List<Output<AccessPolicyEntryArgs>>) {
        this.accessPolicies = Output.all(values)
    }

    /**
     * @param value The vault's create mode to indicate whether the vault need to be recovered or not.
     */
    @JvmName("ucucxwauddnccqod")
    public suspend fun createMode(`value`: Output<CreateMode>) {
        this.createMode = value
    }

    /**
     * @param value Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
     */
    @JvmName("yevbwvvstgevolok")
    public suspend fun enablePurgeProtection(`value`: Output<Boolean>) {
        this.enablePurgeProtection = value
    }

    /**
     * @param value Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored. When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions are always authorized with RBAC.
     */
    @JvmName("lekaldhhcpsqvqmg")
    public suspend fun enableRbacAuthorization(`value`: Output<Boolean>) {
        this.enableRbacAuthorization = value
    }

    /**
     * @param value Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true or false) when creating new key vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
     */
    @JvmName("xewherpxowxxbdty")
    public suspend fun enableSoftDelete(`value`: Output<Boolean>) {
        this.enableSoftDelete = value
    }

    /**
     * @param value Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
     */
    @JvmName("sylxlokcghvdukhb")
    public suspend fun enabledForDeployment(`value`: Output<Boolean>) {
        this.enabledForDeployment = value
    }

    /**
     * @param value Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
     */
    @JvmName("ymyrtxigdvlqvxvb")
    public suspend fun enabledForDiskEncryption(`value`: Output<Boolean>) {
        this.enabledForDiskEncryption = value
    }

    /**
     * @param value Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
     */
    @JvmName("clexbujebclyamac")
    public suspend fun enabledForTemplateDeployment(`value`: Output<Boolean>) {
        this.enabledForTemplateDeployment = value
    }

    /**
     * @param value Rules governing the accessibility of the key vault from specific network locations.
     */
    @JvmName("hgxsduorhqwvfsuy")
    public suspend fun networkAcls(`value`: Output<NetworkRuleSetArgs>) {
        this.networkAcls = value
    }

    /**
     * @param value Provisioning state of the vault.
     */
    @JvmName("moddnicefaqpipxr")
    public suspend fun provisioningState(`value`: Output<Either<String, VaultProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except private endpoint traffic and that that originates from trusted services will be blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor the rules.
     */
    @JvmName("mkkjqusxdnmdsdrc")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value SKU details
     */
    @JvmName("atrfovsqmcgjcsny")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value softDelete data retention days. It accepts >=7 and <=90.
     */
    @JvmName("qtrhxtgttewufqoa")
    public suspend fun softDeleteRetentionInDays(`value`: Output<Int>) {
        this.softDeleteRetentionInDays = value
    }

    /**
     * @param value The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
     */
    @JvmName("shypjqnjqpyamfcn")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The URI of the vault for performing operations on keys and secrets.
     */
    @JvmName("arbtertjqkpexxny")
    public suspend fun vaultUri(`value`: Output<String>) {
        this.vaultUri = value
    }

    /**
     * @param value An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("btflmnmwprscwdug")
    public suspend fun accessPolicies(`value`: List<AccessPolicyEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param argument An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("yttmfdmlmvkusext")
    public suspend
    fun accessPolicies(argument: List<suspend AccessPolicyEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessPolicyEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param argument An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xqltujffhxcgdxlf")
    public suspend fun accessPolicies(
        vararg
        argument: suspend AccessPolicyEntryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessPolicyEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param argument An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bwurpfaqibdhpufb")
    public suspend fun accessPolicies(argument: suspend AccessPolicyEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessPolicyEntryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.accessPolicies = mapped
    }

    /**
     * @param values An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("aybjwqnccphsigqj")
    public suspend fun accessPolicies(vararg values: AccessPolicyEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param value The vault's create mode to indicate whether the vault need to be recovered or not.
     */
    @JvmName("fanwhoerrgcgwguo")
    public suspend fun createMode(`value`: CreateMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
     */
    @JvmName("lfhjmowgqosqalnw")
    public suspend fun enablePurgeProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePurgeProtection = mapped
    }

    /**
     * @param value Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored. When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions are always authorized with RBAC.
     */
    @JvmName("lpswndjstbaxrmno")
    public suspend fun enableRbacAuthorization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRbacAuthorization = mapped
    }

    /**
     * @param value Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true or false) when creating new key vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
     */
    @JvmName("fdlmcrmfubbtatev")
    public suspend fun enableSoftDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSoftDelete = mapped
    }

    /**
     * @param value Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
     */
    @JvmName("qtfeqwwoimrtvlck")
    public suspend fun enabledForDeployment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledForDeployment = mapped
    }

    /**
     * @param value Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
     */
    @JvmName("jncauamrflfhxtab")
    public suspend fun enabledForDiskEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledForDiskEncryption = mapped
    }

    /**
     * @param value Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
     */
    @JvmName("nvxsroochqcesswl")
    public suspend fun enabledForTemplateDeployment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledForTemplateDeployment = mapped
    }

    /**
     * @param value Rules governing the accessibility of the key vault from specific network locations.
     */
    @JvmName("lwvvnodtaiugcipk")
    public suspend fun networkAcls(`value`: NetworkRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAcls = mapped
    }

    /**
     * @param argument Rules governing the accessibility of the key vault from specific network locations.
     */
    @JvmName("smwvrsxixmgytlyo")
    public suspend fun networkAcls(argument: suspend NetworkRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRuleSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkAcls = mapped
    }

    /**
     * @param value Provisioning state of the vault.
     */
    @JvmName("yycbdfwjkqbqkgjn")
    public suspend fun provisioningState(`value`: Either<String, VaultProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the vault.
     */
    @JvmName("rqishicwdctdidca")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VaultProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the vault.
     */
    @JvmName("bsiednggmldefhpx")
    public fun provisioningState(`value`: VaultProvisioningState) {
        val toBeMapped = Either.ofRight<String, VaultProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except private endpoint traffic and that that originates from trusted services will be blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor the rules.
     */
    @JvmName("uhusmiqrurroqcpf")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value SKU details
     */
    @JvmName("yhlpbdmibrskblni")
    public suspend fun sku(`value`: SkuArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU details
     */
    @JvmName("ostrnkwawdefskey")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value softDelete data retention days. It accepts >=7 and <=90.
     */
    @JvmName("nhkkxpavggyoqfso")
    public suspend fun softDeleteRetentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionInDays = mapped
    }

    /**
     * @param value The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
     */
    @JvmName("gdoxtvfyoauefcmq")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The URI of the vault for performing operations on keys and secrets.
     */
    @JvmName("tfdmqjmgwicrgmlb")
    public suspend fun vaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultUri = mapped
    }

    internal fun build(): VaultPropertiesArgs = VaultPropertiesArgs(
        accessPolicies = accessPolicies,
        createMode = createMode,
        enablePurgeProtection = enablePurgeProtection,
        enableRbacAuthorization = enableRbacAuthorization,
        enableSoftDelete = enableSoftDelete,
        enabledForDeployment = enabledForDeployment,
        enabledForDiskEncryption = enabledForDiskEncryption,
        enabledForTemplateDeployment = enabledForTemplateDeployment,
        networkAcls = networkAcls,
        provisioningState = provisioningState,
        publicNetworkAccess = publicNetworkAccess,
        sku = sku ?: throw PulumiNullFieldException("sku"),
        softDeleteRetentionInDays = softDeleteRetentionInDays,
        tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
        vaultUri = vaultUri,
    )
}
