@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A region that this managed HSM Pool has been extended to.
 * @property isPrimary A boolean value that indicates whether the region is the primary region or a secondary region.
 * @property name Name of the geo replicated region.
 * @property provisioningState Provisioning state of the geo replicated region.
 */
public data class MHSMGeoReplicatedRegionResponse(
    public val isPrimary: Boolean? = null,
    public val name: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.MHSMGeoReplicatedRegionResponse):
            MHSMGeoReplicatedRegionResponse = MHSMGeoReplicatedRegionResponse(
            isPrimary = javaType.isPrimary().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
