@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A rule governing the accessibility of a managed hsm pool from a specific virtual network.
 * @property id Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
 */
public data class MHSMVirtualNetworkRuleResponse(
    public val id: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.MHSMVirtualNetworkRuleResponse):
            MHSMVirtualNetworkRuleResponse = MHSMVirtualNetworkRuleResponse(
            id = javaType.id(),
        )
    }
}
