@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import com.pulumi.azurenative.keyvault.kotlin.enums.CertificatePermissions
import com.pulumi.azurenative.keyvault.kotlin.enums.KeyPermissions
import com.pulumi.azurenative.keyvault.kotlin.enums.SecretPermissions
import com.pulumi.azurenative.keyvault.kotlin.enums.StoragePermissions
import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Permissions the identity has for keys, secrets, certificates and storage.
 * @property certificates Permissions to certificates
 * @property keys Permissions to keys
 * @property secrets Permissions to secrets
 * @property storage Permissions to storage accounts
 */
public data class Permissions(
    public val certificates: List<Either<String, CertificatePermissions>>? = null,
    public val keys: List<Either<String, KeyPermissions>>? = null,
    public val secrets: List<Either<String, SecretPermissions>>? = null,
    public val storage: List<Either<String, StoragePermissions>>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.Permissions): Permissions =
            Permissions(
                certificates = javaType.certificates().map({ args0 ->
                    Either.ofLeft<String,
                        CertificatePermissions,>(args0)
                }),
                keys = javaType.keys().map({ args0 -> Either.ofLeft<String, KeyPermissions>(args0) }),
                secrets = javaType.secrets().map({ args0 -> Either.ofLeft<String, SecretPermissions>(args0) }),
                storage = javaType.storage().map({ args0 -> Either.ofLeft<String, StoragePermissions>(args0) }),
            )
    }
}
