@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ComplianceStatusResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.HelmOperatorPropertiesResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ComplianceStatusResponse.Companion.toKotlin as complianceStatusResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.HelmOperatorPropertiesResponse.Companion.toKotlin as helmOperatorPropertiesResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SourceControlConfiguration].
 */
@PulumiTagMarker
public class SourceControlConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SourceControlConfigurationArgs = SourceControlConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SourceControlConfigurationArgsBuilder.() -> Unit) {
        val builder = SourceControlConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SourceControlConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SourceControlConfiguration(builtJavaResource)
    }
}

/**
 * The SourceControl Configuration object returned in Get & Put response.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2019-11-01-preview.
 * ## Example Usage
 * ### Create Source Control Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sourceControlConfiguration = new AzureNative.KubernetesConfiguration.SourceControlConfiguration("sourceControlConfiguration", new()
 *     {
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         ConfigurationProtectedSettings =
 *         {
 *             { "protectedSetting1Key", "protectedSetting1Value" },
 *         },
 *         EnableHelmOperator = true,
 *         HelmOperatorProperties = new AzureNative.KubernetesConfiguration.Inputs.HelmOperatorPropertiesArgs
 *         {
 *             ChartValues = "--set git.ssh.secretName=flux-git-deploy --set tillerNamespace=kube-system",
 *             ChartVersion = "0.3.0",
 *         },
 *         OperatorInstanceName = "SRSGitHubFluxOp-01",
 *         OperatorNamespace = "SRS_Namespace",
 *         OperatorParams = "--git-email=xyzgituser@users.srs.github.com",
 *         OperatorScope = AzureNative.KubernetesConfiguration.OperatorScopeType.@Namespace,
 *         OperatorType = AzureNative.KubernetesConfiguration.OperatorType.Flux,
 *         RepositoryUrl = "git@github.com:k8sdeveloper425/flux-get-started",
 *         ResourceGroupName = "rg1",
 *         SourceControlConfigurationName = "SRS_GitHubConfig",
 *         SshKnownHostsContents = "c3NoLmRldi5henVyZS5jb20gc3NoLXJzYSBBQUFBQjNOemFDMXljMkVBQUFBREFRQUJBQUFCQVFDN0hyMW9UV3FOcU9sekdKT2ZHSjROYWtWeUl6ZjFyWFlkNGQ3d282akJsa0x2Q0E0b2RCbEwwbURVeVowL1FVZlRUcWV1K3RtMjJnT3N2K1ZyVlRNazZ2d1JVNzVnWS95OXV0NU1iM2JSNUJWNThkS1h5cTlBOVVlQjVDYWtlaG41WmdtNngxbUtvVnlmK0ZGbjI2aVlxWEpSZ3pJWlpjWjVWNmhyRTBRZzM5a1ptNGF6NDhvMEFVYmY2U3A0U0xkdm51TWEyc1ZOd0hCYm9TN0VKa201N1hRUFZVMy9RcHlOTEhiV0Rkend0cmxTK2V6MzBTM0FkWWhMS0VPeEFHOHdlT255cnRMSkFVZW45bVRrb2w4b0lJMWVkZjdtV1diV1ZmMG5CbWx5MjErblpjbUNUSVNRQnRkY3lQYUVubzdmRlFNREQyNi9zMGxmS29iNEt3OEg=",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewSourceControlConfiguration(ctx, "sourceControlConfiguration", &kubernetesconfiguration.SourceControlConfigurationArgs{
 * 			ClusterName:         pulumi.String("clusterName1"),
 * 			ClusterResourceName: pulumi.String("connectedClusters"),
 * 			ClusterRp:           pulumi.String("Microsoft.Kubernetes"),
 * 			ConfigurationProtectedSettings: pulumi.StringMap{
 * 				"protectedSetting1Key": pulumi.String("protectedSetting1Value"),
 * 			},
 * 			EnableHelmOperator: pulumi.Bool(true),
 * 			HelmOperatorProperties: &kubernetesconfiguration.HelmOperatorPropertiesArgs{
 * 				ChartValues:  pulumi.String("--set git.ssh.secretName=flux-git-deploy --set tillerNamespace=kube-system"),
 * 				ChartVersion: pulumi.String("0.3.0"),
 * 			},
 * 			OperatorInstanceName:           pulumi.String("SRSGitHubFluxOp-01"),
 * 			OperatorNamespace:              pulumi.String("SRS_Namespace"),
 * 			OperatorParams:                 pulumi.String("--git-email=xyzgituser@users.srs.github.com"),
 * 			OperatorScope:                  pulumi.String(kubernetesconfiguration.OperatorScopeTypeNamespace),
 * 			OperatorType:                   pulumi.String(kubernetesconfiguration.OperatorTypeFlux),
 * 			RepositoryUrl:                  pulumi.String("git@github.com:k8sdeveloper425/flux-get-started"),
 * 			ResourceGroupName:              pulumi.String("rg1"),
 * 			SourceControlConfigurationName: pulumi.String("SRS_GitHubConfig"),
 * 			SshKnownHostsContents:          pulumi.String("c3NoLmRldi5henVyZS5jb20gc3NoLXJzYSBBQUFBQjNOemFDMXljMkVBQUFBREFRQUJBQUFCQVFDN0hyMW9UV3FOcU9sekdKT2ZHSjROYWtWeUl6ZjFyWFlkNGQ3d282akJsa0x2Q0E0b2RCbEwwbURVeVowL1FVZlRUcWV1K3RtMjJnT3N2K1ZyVlRNazZ2d1JVNzVnWS95OXV0NU1iM2JSNUJWNThkS1h5cTlBOVVlQjVDYWtlaG41WmdtNngxbUtvVnlmK0ZGbjI2aVlxWEpSZ3pJWlpjWjVWNmhyRTBRZzM5a1ptNGF6NDhvMEFVYmY2U3A0U0xkdm51TWEyc1ZOd0hCYm9TN0VKa201N1hRUFZVMy9RcHlOTEhiV0Rkend0cmxTK2V6MzBTM0FkWWhMS0VPeEFHOHdlT255cnRMSkFVZW45bVRrb2w4b0lJMWVkZjdtV1diV1ZmMG5CbWx5MjErblpjbUNUSVNRQnRkY3lQYUVubzdmRlFNREQyNi9zMGxmS29iNEt3OEg="),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfiguration;
 * import com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfigurationArgs;
 * import com.pulumi.azurenative.kubernetesconfiguration.inputs.HelmOperatorPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sourceControlConfiguration = new SourceControlConfiguration("sourceControlConfiguration", SourceControlConfigurationArgs.builder()
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .configurationProtectedSettings(Map.of("protectedSetting1Key", "protectedSetting1Value"))
 *             .enableHelmOperator(true)
 *             .helmOperatorProperties(HelmOperatorPropertiesArgs.builder()
 *                 .chartValues("--set git.ssh.secretName=flux-git-deploy --set tillerNamespace=kube-system")
 *                 .chartVersion("0.3.0")
 *                 .build())
 *             .operatorInstanceName("SRSGitHubFluxOp-01")
 *             .operatorNamespace("SRS_Namespace")
 *             .operatorParams("--git-email=xyzgituser@users.srs.github.com")
 *             .operatorScope("namespace")
 *             .operatorType("Flux")
 *             .repositoryUrl("git@github.com:k8sdeveloper425/flux-get-started")
 *             .resourceGroupName("rg1")
 *             .sourceControlConfigurationName("SRS_GitHubConfig")
 *             .sshKnownHostsContents("c3NoLmRldi5henVyZS5jb20gc3NoLXJzYSBBQUFBQjNOemFDMXljMkVBQUFBREFRQUJBQUFCQVFDN0hyMW9UV3FOcU9sekdKT2ZHSjROYWtWeUl6ZjFyWFlkNGQ3d282akJsa0x2Q0E0b2RCbEwwbURVeVowL1FVZlRUcWV1K3RtMjJnT3N2K1ZyVlRNazZ2d1JVNzVnWS95OXV0NU1iM2JSNUJWNThkS1h5cTlBOVVlQjVDYWtlaG41WmdtNngxbUtvVnlmK0ZGbjI2aVlxWEpSZ3pJWlpjWjVWNmhyRTBRZzM5a1ptNGF6NDhvMEFVYmY2U3A0U0xkdm51TWEyc1ZOd0hCYm9TN0VKa201N1hRUFZVMy9RcHlOTEhiV0Rkend0cmxTK2V6MzBTM0FkWWhMS0VPeEFHOHdlT255cnRMSkFVZW45bVRrb2w4b0lJMWVkZjdtV1diV1ZmMG5CbWx5MjErblpjbUNUSVNRQnRkY3lQYUVubzdmRlFNREQyNi9zMGxmS29iNEt3OEg=")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesconfiguration:SourceControlConfiguration SRS_GitHubConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{clusterRp}/{clusterResourceName}/{clusterName}/providers/Microsoft.KubernetesConfiguration/sourceControlConfigurations/{sourceControlConfigurationName}
 * ```
 */
public class SourceControlConfiguration internal constructor(
    override val javaResource:
    com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfiguration,
) : KotlinCustomResource(javaResource, SourceControlConfigurationMapper) {
    /**
     * Compliance Status of the Configuration
     */
    public val complianceStatus: Output<ComplianceStatusResponse>
        get() = javaResource.complianceStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                complianceStatusResponseToKotlin(args0)
            })
        })

    /**
     * Name-value pairs of protected configuration settings for the configuration
     */
    public val configurationProtectedSettings: Output<Map<String, String>>?
        get() = javaResource.configurationProtectedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Option to enable Helm Operator for this git configuration.
     */
    public val enableHelmOperator: Output<Boolean>?
        get() = javaResource.enableHelmOperator().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Properties for Helm operator.
     */
    public val helmOperatorProperties: Output<HelmOperatorPropertiesResponse>?
        get() = javaResource.helmOperatorProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> helmOperatorPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Instance name of the operator - identifying the specific configuration.
     */
    public val operatorInstanceName: Output<String>?
        get() = javaResource.operatorInstanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The namespace to which this operator is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
     */
    public val operatorNamespace: Output<String>?
        get() = javaResource.operatorNamespace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Any Parameters for the Operator instance in string format.
     */
    public val operatorParams: Output<String>?
        get() = javaResource.operatorParams().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Scope at which the operator will be installed.
     */
    public val operatorScope: Output<String>?
        get() = javaResource.operatorScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the operator
     */
    public val operatorType: Output<String>?
        get() = javaResource.operatorType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource provider.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Public Key associated with this SourceControl configuration (either generated within the cluster or provided by the user).
     */
    public val repositoryPublicKey: Output<String>
        get() = javaResource.repositoryPublicKey().applyValue({ args0 -> args0 })

    /**
     * Url of the SourceControl Repository.
     */
    public val repositoryUrl: Output<String>?
        get() = javaResource.repositoryUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Base64-encoded known_hosts contents containing public SSH keys required to access private Git instances
     */
    public val sshKnownHostsContents: Output<String>?
        get() = javaResource.sshKnownHostsContents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SourceControlConfigurationMapper : ResourceMapper<SourceControlConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): SourceControlConfiguration =
        SourceControlConfiguration(
            javaResource as
                com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfiguration,
        )
}

/**
 * @see [SourceControlConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SourceControlConfiguration].
 */
public suspend fun sourceControlConfiguration(
    name: String,
    block: suspend SourceControlConfigurationResourceBuilder.() -> Unit,
):
    SourceControlConfiguration {
    val builder = SourceControlConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SourceControlConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sourceControlConfiguration(name: String): SourceControlConfiguration {
    val builder = SourceControlConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
