@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfigurationArgs.builder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums.OperatorScopeType
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums.OperatorType
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.HelmOperatorPropertiesArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.HelmOperatorPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The SourceControl Configuration object returned in Get & Put response.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2019-11-01-preview.
 * ## Example Usage
 * ### Create Source Control Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sourceControlConfiguration = new AzureNative.KubernetesConfiguration.SourceControlConfiguration("sourceControlConfiguration", new()
 *     {
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         ConfigurationProtectedSettings =
 *         {
 *             { "protectedSetting1Key", "protectedSetting1Value" },
 *         },
 *         EnableHelmOperator = true,
 *         HelmOperatorProperties = new AzureNative.KubernetesConfiguration.Inputs.HelmOperatorPropertiesArgs
 *         {
 *             ChartValues = "--set git.ssh.secretName=flux-git-deploy --set tillerNamespace=kube-system",
 *             ChartVersion = "0.3.0",
 *         },
 *         OperatorInstanceName = "SRSGitHubFluxOp-01",
 *         OperatorNamespace = "SRS_Namespace",
 *         OperatorParams = "--git-email=xyzgituser@users.srs.github.com",
 *         OperatorScope = AzureNative.KubernetesConfiguration.OperatorScopeType.@Namespace,
 *         OperatorType = AzureNative.KubernetesConfiguration.OperatorType.Flux,
 *         RepositoryUrl = "git@github.com:k8sdeveloper425/flux-get-started",
 *         ResourceGroupName = "rg1",
 *         SourceControlConfigurationName = "SRS_GitHubConfig",
 *         SshKnownHostsContents = "c3NoLmRldi5henVyZS5jb20gc3NoLXJzYSBBQUFBQjNOemFDMXljMkVBQUFBREFRQUJBQUFCQVFDN0hyMW9UV3FOcU9sekdKT2ZHSjROYWtWeUl6ZjFyWFlkNGQ3d282akJsa0x2Q0E0b2RCbEwwbURVeVowL1FVZlRUcWV1K3RtMjJnT3N2K1ZyVlRNazZ2d1JVNzVnWS95OXV0NU1iM2JSNUJWNThkS1h5cTlBOVVlQjVDYWtlaG41WmdtNngxbUtvVnlmK0ZGbjI2aVlxWEpSZ3pJWlpjWjVWNmhyRTBRZzM5a1ptNGF6NDhvMEFVYmY2U3A0U0xkdm51TWEyc1ZOd0hCYm9TN0VKa201N1hRUFZVMy9RcHlOTEhiV0Rkend0cmxTK2V6MzBTM0FkWWhMS0VPeEFHOHdlT255cnRMSkFVZW45bVRrb2w4b0lJMWVkZjdtV1diV1ZmMG5CbWx5MjErblpjbUNUSVNRQnRkY3lQYUVubzdmRlFNREQyNi9zMGxmS29iNEt3OEg=",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewSourceControlConfiguration(ctx, "sourceControlConfiguration", &kubernetesconfiguration.SourceControlConfigurationArgs{
 * 			ClusterName:         pulumi.String("clusterName1"),
 * 			ClusterResourceName: pulumi.String("connectedClusters"),
 * 			ClusterRp:           pulumi.String("Microsoft.Kubernetes"),
 * 			ConfigurationProtectedSettings: pulumi.StringMap{
 * 				"protectedSetting1Key": pulumi.String("protectedSetting1Value"),
 * 			},
 * 			EnableHelmOperator: pulumi.Bool(true),
 * 			HelmOperatorProperties: &kubernetesconfiguration.HelmOperatorPropertiesArgs{
 * 				ChartValues:  pulumi.String("--set git.ssh.secretName=flux-git-deploy --set tillerNamespace=kube-system"),
 * 				ChartVersion: pulumi.String("0.3.0"),
 * 			},
 * 			OperatorInstanceName:           pulumi.String("SRSGitHubFluxOp-01"),
 * 			OperatorNamespace:              pulumi.String("SRS_Namespace"),
 * 			OperatorParams:                 pulumi.String("--git-email=xyzgituser@users.srs.github.com"),
 * 			OperatorScope:                  pulumi.String(kubernetesconfiguration.OperatorScopeTypeNamespace),
 * 			OperatorType:                   pulumi.String(kubernetesconfiguration.OperatorTypeFlux),
 * 			RepositoryUrl:                  pulumi.String("git@github.com:k8sdeveloper425/flux-get-started"),
 * 			ResourceGroupName:              pulumi.String("rg1"),
 * 			SourceControlConfigurationName: pulumi.String("SRS_GitHubConfig"),
 * 			SshKnownHostsContents:          pulumi.String("c3NoLmRldi5henVyZS5jb20gc3NoLXJzYSBBQUFBQjNOemFDMXljMkVBQUFBREFRQUJBQUFCQVFDN0hyMW9UV3FOcU9sekdKT2ZHSjROYWtWeUl6ZjFyWFlkNGQ3d282akJsa0x2Q0E0b2RCbEwwbURVeVowL1FVZlRUcWV1K3RtMjJnT3N2K1ZyVlRNazZ2d1JVNzVnWS95OXV0NU1iM2JSNUJWNThkS1h5cTlBOVVlQjVDYWtlaG41WmdtNngxbUtvVnlmK0ZGbjI2aVlxWEpSZ3pJWlpjWjVWNmhyRTBRZzM5a1ptNGF6NDhvMEFVYmY2U3A0U0xkdm51TWEyc1ZOd0hCYm9TN0VKa201N1hRUFZVMy9RcHlOTEhiV0Rkend0cmxTK2V6MzBTM0FkWWhMS0VPeEFHOHdlT255cnRMSkFVZW45bVRrb2w4b0lJMWVkZjdtV1diV1ZmMG5CbWx5MjErblpjbUNUSVNRQnRkY3lQYUVubzdmRlFNREQyNi9zMGxmS29iNEt3OEg="),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfiguration;
 * import com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfigurationArgs;
 * import com.pulumi.azurenative.kubernetesconfiguration.inputs.HelmOperatorPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sourceControlConfiguration = new SourceControlConfiguration("sourceControlConfiguration", SourceControlConfigurationArgs.builder()
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .configurationProtectedSettings(Map.of("protectedSetting1Key", "protectedSetting1Value"))
 *             .enableHelmOperator(true)
 *             .helmOperatorProperties(HelmOperatorPropertiesArgs.builder()
 *                 .chartValues("--set git.ssh.secretName=flux-git-deploy --set tillerNamespace=kube-system")
 *                 .chartVersion("0.3.0")
 *                 .build())
 *             .operatorInstanceName("SRSGitHubFluxOp-01")
 *             .operatorNamespace("SRS_Namespace")
 *             .operatorParams("--git-email=xyzgituser@users.srs.github.com")
 *             .operatorScope("namespace")
 *             .operatorType("Flux")
 *             .repositoryUrl("git@github.com:k8sdeveloper425/flux-get-started")
 *             .resourceGroupName("rg1")
 *             .sourceControlConfigurationName("SRS_GitHubConfig")
 *             .sshKnownHostsContents("c3NoLmRldi5henVyZS5jb20gc3NoLXJzYSBBQUFBQjNOemFDMXljMkVBQUFBREFRQUJBQUFCQVFDN0hyMW9UV3FOcU9sekdKT2ZHSjROYWtWeUl6ZjFyWFlkNGQ3d282akJsa0x2Q0E0b2RCbEwwbURVeVowL1FVZlRUcWV1K3RtMjJnT3N2K1ZyVlRNazZ2d1JVNzVnWS95OXV0NU1iM2JSNUJWNThkS1h5cTlBOVVlQjVDYWtlaG41WmdtNngxbUtvVnlmK0ZGbjI2aVlxWEpSZ3pJWlpjWjVWNmhyRTBRZzM5a1ptNGF6NDhvMEFVYmY2U3A0U0xkdm51TWEyc1ZOd0hCYm9TN0VKa201N1hRUFZVMy9RcHlOTEhiV0Rkend0cmxTK2V6MzBTM0FkWWhMS0VPeEFHOHdlT255cnRMSkFVZW45bVRrb2w4b0lJMWVkZjdtV1diV1ZmMG5CbWx5MjErblpjbUNUSVNRQnRkY3lQYUVubzdmRlFNREQyNi9zMGxmS29iNEt3OEg=")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesconfiguration:SourceControlConfiguration SRS_GitHubConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{clusterRp}/{clusterResourceName}/{clusterName}/providers/Microsoft.KubernetesConfiguration/sourceControlConfigurations/{sourceControlConfigurationName}
 * ```
 * @property clusterName The name of the kubernetes cluster.
 * @property clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
 * @property clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
 * @property configurationProtectedSettings Name-value pairs of protected configuration settings for the configuration
 * @property enableHelmOperator Option to enable Helm Operator for this git configuration.
 * @property helmOperatorProperties Properties for Helm operator.
 * @property operatorInstanceName Instance name of the operator - identifying the specific configuration.
 * @property operatorNamespace The namespace to which this operator is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
 * @property operatorParams Any Parameters for the Operator instance in string format.
 * @property operatorScope Scope at which the operator will be installed.
 * @property operatorType Type of the operator
 * @property repositoryUrl Url of the SourceControl Repository.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceControlConfigurationName Name of the Source Control Configuration.
 * @property sshKnownHostsContents Base64-encoded known_hosts contents containing public SSH keys required to access private Git instances
 */
public data class SourceControlConfigurationArgs(
    public val clusterName: Output<String>? = null,
    public val clusterResourceName: Output<String>? = null,
    public val clusterRp: Output<String>? = null,
    public val configurationProtectedSettings: Output<Map<String, String>>? = null,
    public val enableHelmOperator: Output<Boolean>? = null,
    public val helmOperatorProperties: Output<HelmOperatorPropertiesArgs>? = null,
    public val operatorInstanceName: Output<String>? = null,
    public val operatorNamespace: Output<String>? = null,
    public val operatorParams: Output<String>? = null,
    public val operatorScope: Output<Either<String, OperatorScopeType>>? = null,
    public val operatorType: Output<Either<String, OperatorType>>? = null,
    public val repositoryUrl: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceControlConfigurationName: Output<String>? = null,
    public val sshKnownHostsContents: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfigurationArgs =
        com.pulumi.azurenative.kubernetesconfiguration.SourceControlConfigurationArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterResourceName(clusterResourceName?.applyValue({ args0 -> args0 }))
            .clusterRp(clusterRp?.applyValue({ args0 -> args0 }))
            .configurationProtectedSettings(
                configurationProtectedSettings?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .enableHelmOperator(enableHelmOperator?.applyValue({ args0 -> args0 }))
            .helmOperatorProperties(
                helmOperatorProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .operatorInstanceName(operatorInstanceName?.applyValue({ args0 -> args0 }))
            .operatorNamespace(operatorNamespace?.applyValue({ args0 -> args0 }))
            .operatorParams(operatorParams?.applyValue({ args0 -> args0 }))
            .operatorScope(
                operatorScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .operatorType(
                operatorType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .repositoryUrl(repositoryUrl?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceControlConfigurationName(sourceControlConfigurationName?.applyValue({ args0 -> args0 }))
            .sshKnownHostsContents(sshKnownHostsContents?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SourceControlConfigurationArgs].
 */
@PulumiTagMarker
public class SourceControlConfigurationArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var clusterResourceName: Output<String>? = null

    private var clusterRp: Output<String>? = null

    private var configurationProtectedSettings: Output<Map<String, String>>? = null

    private var enableHelmOperator: Output<Boolean>? = null

    private var helmOperatorProperties: Output<HelmOperatorPropertiesArgs>? = null

    private var operatorInstanceName: Output<String>? = null

    private var operatorNamespace: Output<String>? = null

    private var operatorParams: Output<String>? = null

    private var operatorScope: Output<Either<String, OperatorScopeType>>? = null

    private var operatorType: Output<Either<String, OperatorType>>? = null

    private var repositoryUrl: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceControlConfigurationName: Output<String>? = null

    private var sshKnownHostsContents: Output<String>? = null

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("dubvjvbuklaekjlh")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("ucjkhxbwlcdnhtnn")
    public suspend fun clusterResourceName(`value`: Output<String>) {
        this.clusterResourceName = value
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("gguffwqlmmpprgmq")
    public suspend fun clusterRp(`value`: Output<String>) {
        this.clusterRp = value
    }

    /**
     * @param value Name-value pairs of protected configuration settings for the configuration
     */
    @JvmName("mjhfffpxrkrtitor")
    public suspend fun configurationProtectedSettings(`value`: Output<Map<String, String>>) {
        this.configurationProtectedSettings = value
    }

    /**
     * @param value Option to enable Helm Operator for this git configuration.
     */
    @JvmName("ugrhgoqhauofrayi")
    public suspend fun enableHelmOperator(`value`: Output<Boolean>) {
        this.enableHelmOperator = value
    }

    /**
     * @param value Properties for Helm operator.
     */
    @JvmName("otfcnqjchnoudlio")
    public suspend fun helmOperatorProperties(`value`: Output<HelmOperatorPropertiesArgs>) {
        this.helmOperatorProperties = value
    }

    /**
     * @param value Instance name of the operator - identifying the specific configuration.
     */
    @JvmName("eulamtlljqgdqkbu")
    public suspend fun operatorInstanceName(`value`: Output<String>) {
        this.operatorInstanceName = value
    }

    /**
     * @param value The namespace to which this operator is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
     */
    @JvmName("klowwphlbilromev")
    public suspend fun operatorNamespace(`value`: Output<String>) {
        this.operatorNamespace = value
    }

    /**
     * @param value Any Parameters for the Operator instance in string format.
     */
    @JvmName("xhxsetlaaxribxpf")
    public suspend fun operatorParams(`value`: Output<String>) {
        this.operatorParams = value
    }

    /**
     * @param value Scope at which the operator will be installed.
     */
    @JvmName("dkwlrjwfsgvsdqdk")
    public suspend fun operatorScope(`value`: Output<Either<String, OperatorScopeType>>) {
        this.operatorScope = value
    }

    /**
     * @param value Type of the operator
     */
    @JvmName("ddbtbftsdpskewpc")
    public suspend fun operatorType(`value`: Output<Either<String, OperatorType>>) {
        this.operatorType = value
    }

    /**
     * @param value Url of the SourceControl Repository.
     */
    @JvmName("bjirhayeqxqicspb")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sbspnsbbaefwrurw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the Source Control Configuration.
     */
    @JvmName("kqqhivghmyvjpvff")
    public suspend fun sourceControlConfigurationName(`value`: Output<String>) {
        this.sourceControlConfigurationName = value
    }

    /**
     * @param value Base64-encoded known_hosts contents containing public SSH keys required to access private Git instances
     */
    @JvmName("llseakwaatrxqujc")
    public suspend fun sshKnownHostsContents(`value`: Output<String>) {
        this.sshKnownHostsContents = value
    }

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("slgjaumkkrcqpdfy")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("rgonitatxratnswq")
    public suspend fun clusterResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterResourceName = mapped
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("vgfycqnwbavomeco")
    public suspend fun clusterRp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterRp = mapped
    }

    /**
     * @param value Name-value pairs of protected configuration settings for the configuration
     */
    @JvmName("kjxamkewjmasylbl")
    public suspend fun configurationProtectedSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProtectedSettings = mapped
    }

    /**
     * @param values Name-value pairs of protected configuration settings for the configuration
     */
    @JvmName("pkxwpqmoqnuvykmw")
    public fun configurationProtectedSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationProtectedSettings = mapped
    }

    /**
     * @param value Option to enable Helm Operator for this git configuration.
     */
    @JvmName("bnbqigrktbeslkkw")
    public suspend fun enableHelmOperator(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHelmOperator = mapped
    }

    /**
     * @param value Properties for Helm operator.
     */
    @JvmName("xewsjopddairfxho")
    public suspend fun helmOperatorProperties(`value`: HelmOperatorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helmOperatorProperties = mapped
    }

    /**
     * @param argument Properties for Helm operator.
     */
    @JvmName("iscpebateyhcqbxb")
    public suspend
    fun helmOperatorProperties(argument: suspend HelmOperatorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = HelmOperatorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.helmOperatorProperties = mapped
    }

    /**
     * @param value Instance name of the operator - identifying the specific configuration.
     */
    @JvmName("lmfwxuuvjcbkagoa")
    public suspend fun operatorInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatorInstanceName = mapped
    }

    /**
     * @param value The namespace to which this operator is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
     */
    @JvmName("ijeieaaqtenjpeob")
    public suspend fun operatorNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatorNamespace = mapped
    }

    /**
     * @param value Any Parameters for the Operator instance in string format.
     */
    @JvmName("fkdmwcfaykgcdrxw")
    public suspend fun operatorParams(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatorParams = mapped
    }

    /**
     * @param value Scope at which the operator will be installed.
     */
    @JvmName("whawmetsgarkyaox")
    public suspend fun operatorScope(`value`: Either<String, OperatorScopeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatorScope = mapped
    }

    /**
     * @param value Scope at which the operator will be installed.
     */
    @JvmName("bhkvotmluervdsyq")
    public fun operatorScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatorScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorScope = mapped
    }

    /**
     * @param value Scope at which the operator will be installed.
     */
    @JvmName("lclonkqrpttngtug")
    public fun operatorScope(`value`: OperatorScopeType) {
        val toBeMapped = Either.ofRight<String, OperatorScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorScope = mapped
    }

    /**
     * @param value Type of the operator
     */
    @JvmName("xwhbsdgxhrrwixfg")
    public suspend fun operatorType(`value`: Either<String, OperatorType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value Type of the operator
     */
    @JvmName("sdvvqtvuuehppaaa")
    public fun operatorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value Type of the operator
     */
    @JvmName("hwkwtevououbqsgy")
    public fun operatorType(`value`: OperatorType) {
        val toBeMapped = Either.ofRight<String, OperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value Url of the SourceControl Repository.
     */
    @JvmName("wsdqlvbhtnghncyf")
    public suspend fun repositoryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cewqfingwvmcuibj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Source Control Configuration.
     */
    @JvmName("araskbjdwfuiwwpa")
    public suspend fun sourceControlConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceControlConfigurationName = mapped
    }

    /**
     * @param value Base64-encoded known_hosts contents containing public SSH keys required to access private Git instances
     */
    @JvmName("cvxkbktosqvilnpr")
    public suspend fun sshKnownHostsContents(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshKnownHostsContents = mapped
    }

    internal fun build(): SourceControlConfigurationArgs = SourceControlConfigurationArgs(
        clusterName = clusterName,
        clusterResourceName = clusterResourceName,
        clusterRp = clusterRp,
        configurationProtectedSettings = configurationProtectedSettings,
        enableHelmOperator = enableHelmOperator,
        helmOperatorProperties = helmOperatorProperties,
        operatorInstanceName = operatorInstanceName,
        operatorNamespace = operatorNamespace,
        operatorParams = operatorParams,
        operatorScope = operatorScope,
        operatorType = operatorType,
        repositoryUrl = repositoryUrl,
        resourceGroupName = resourceGroupName,
        sourceControlConfigurationName = sourceControlConfigurationName,
        sshKnownHostsContents = sshKnownHostsContents,
    )
}
