@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Scope at which the operator will be installed.
 */
public enum class ScopeType(
    public val javaValue: com.pulumi.azurenative.kubernetesconfiguration.enums.ScopeType,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.enums.ScopeType> {
    Cluster(com.pulumi.azurenative.kubernetesconfiguration.enums.ScopeType.Cluster),
    Namespace(com.pulumi.azurenative.kubernetesconfiguration.enums.ScopeType.Namespace),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.enums.ScopeType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.enums.ScopeType):
            ScopeType = ScopeType.values().first { it.javaValue == javaType }
    }
}
