@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.ExtensionStatusArgs.builder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums.LevelType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Status from the extension.
 * @property code Status code provided by the Extension
 * @property displayStatus Short description of status of the extension.
 * @property level Level of the status.
 * @property message Detailed message of the status from the Extension.
 * @property time DateLiteral (per ISO8601) noting the time of installation status.
 */
public data class ExtensionStatusArgs(
    public val code: Output<String>? = null,
    public val displayStatus: Output<String>? = null,
    public val level: Output<Either<String, LevelType>>? = null,
    public val message: Output<String>? = null,
    public val time: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.ExtensionStatusArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.ExtensionStatusArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ExtensionStatusArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .displayStatus(displayStatus?.applyValue({ args0 -> args0 }))
            .level(
                level?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .message(message?.applyValue({ args0 -> args0 }))
            .time(time?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionStatusArgs].
 */
@PulumiTagMarker
public class ExtensionStatusArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var displayStatus: Output<String>? = null

    private var level: Output<Either<String, LevelType>>? = null

    private var message: Output<String>? = null

    private var time: Output<String>? = null

    /**
     * @param value Status code provided by the Extension
     */
    @JvmName("rbrysykfhvymxxny")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Short description of status of the extension.
     */
    @JvmName("yeraxhnuyuqurmvd")
    public suspend fun displayStatus(`value`: Output<String>) {
        this.displayStatus = value
    }

    /**
     * @param value Level of the status.
     */
    @JvmName("ccngojwvfvgsxuie")
    public suspend fun level(`value`: Output<Either<String, LevelType>>) {
        this.level = value
    }

    /**
     * @param value Detailed message of the status from the Extension.
     */
    @JvmName("ifdotjmxpfnbwxav")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value DateLiteral (per ISO8601) noting the time of installation status.
     */
    @JvmName("rjviimqkybeybqnx")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value Status code provided by the Extension
     */
    @JvmName("ejvcuytflxvdejgo")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Short description of status of the extension.
     */
    @JvmName("nfkohtyfuiuguscd")
    public suspend fun displayStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayStatus = mapped
    }

    /**
     * @param value Level of the status.
     */
    @JvmName("vnpgihepfhlptwkq")
    public suspend fun level(`value`: Either<String, LevelType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Level of the status.
     */
    @JvmName("ntpfahunppjkdaae")
    public fun level(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LevelType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Level of the status.
     */
    @JvmName("oqoybvtvwnvdxilx")
    public fun level(`value`: LevelType) {
        val toBeMapped = Either.ofRight<String, LevelType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Detailed message of the status from the Extension.
     */
    @JvmName("onmjmplqwkevpbdd")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value DateLiteral (per ISO8601) noting the time of installation status.
     */
    @JvmName("kedggxvumjnhveog")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    internal fun build(): ExtensionStatusArgs = ExtensionStatusArgs(
        code = code,
        displayStatus = displayStatus,
        level = level,
        message = message,
        time = time,
    )
}
