@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.HelmOperatorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties for Helm operator.
 * @property chartValues Values override for the operator Helm chart.
 * @property chartVersion Version of the operator Helm chart.
 */
public data class HelmOperatorPropertiesArgs(
    public val chartValues: Output<String>? = null,
    public val chartVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.HelmOperatorPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.HelmOperatorPropertiesArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.HelmOperatorPropertiesArgs.builder()
            .chartValues(chartValues?.applyValue({ args0 -> args0 }))
            .chartVersion(chartVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HelmOperatorPropertiesArgs].
 */
@PulumiTagMarker
public class HelmOperatorPropertiesArgsBuilder internal constructor() {
    private var chartValues: Output<String>? = null

    private var chartVersion: Output<String>? = null

    /**
     * @param value Values override for the operator Helm chart.
     */
    @JvmName("cyxlsyvtgxweetkq")
    public suspend fun chartValues(`value`: Output<String>) {
        this.chartValues = value
    }

    /**
     * @param value Version of the operator Helm chart.
     */
    @JvmName("jmdhenqjnoptnnpi")
    public suspend fun chartVersion(`value`: Output<String>) {
        this.chartVersion = value
    }

    /**
     * @param value Values override for the operator Helm chart.
     */
    @JvmName("krtbmymvhjlahrhf")
    public suspend fun chartValues(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chartValues = mapped
    }

    /**
     * @param value Version of the operator Helm chart.
     */
    @JvmName("pvqbdroeyvnabkrr")
    public suspend fun chartVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chartVersion = mapped
    }

    internal fun build(): HelmOperatorPropertiesArgs = HelmOperatorPropertiesArgs(
        chartValues = chartValues,
        chartVersion = chartVersion,
    )
}
