@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.KubernetesConfigurationPrivateLinkScopePropertiesArgs.builder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums.PublicNetworkAccessType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties that define a Azure Arc PrivateLinkScope resource.
 * @property clusterResourceId Managed Cluster ARM ID for the private link scope  (Required)
 * @property publicNetworkAccess Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
 */
public data class KubernetesConfigurationPrivateLinkScopePropertiesArgs(
    public val clusterResourceId: Output<String>,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.KubernetesConfigurationPrivateLinkScopePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.KubernetesConfigurationPrivateLinkScopePropertiesArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.KubernetesConfigurationPrivateLinkScopePropertiesArgs.builder()
            .clusterResourceId(clusterResourceId.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [KubernetesConfigurationPrivateLinkScopePropertiesArgs].
 */
@PulumiTagMarker
public class KubernetesConfigurationPrivateLinkScopePropertiesArgsBuilder internal constructor() {
    private var clusterResourceId: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessType>>? = null

    /**
     * @param value Managed Cluster ARM ID for the private link scope  (Required)
     */
    @JvmName("nrypgnndcccxuisx")
    public suspend fun clusterResourceId(`value`: Output<String>) {
        this.clusterResourceId = value
    }

    /**
     * @param value Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
     */
    @JvmName("rweooyfkqvvskdha")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessType>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Managed Cluster ARM ID for the private link scope  (Required)
     */
    @JvmName("leyhfrsjmyrghpkn")
    public suspend fun clusterResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterResourceId = mapped
    }

    /**
     * @param value Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
     */
    @JvmName("lsrtrkmyxufqiqoh")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
     */
    @JvmName("xlbnwrwitlonsmug")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
     */
    @JvmName("txwfyhqhbhbkmfjx")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    internal fun build(): KubernetesConfigurationPrivateLinkScopePropertiesArgs =
        KubernetesConfigurationPrivateLinkScopePropertiesArgs(
            clusterResourceId = clusterResourceId ?: throw PulumiNullFieldException("clusterResourceId"),
            publicNetworkAccess = publicNetworkAccess,
        )
}
