@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.KustomizationDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Kustomization defining how to reconcile the artifact pulled by the source type on the cluster.
 * @property dependsOn Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
 * @property force Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
 * @property path The path in the source reference to reconcile on the cluster.
 * @property postBuild Used for variable substitution for this Kustomization after kustomize build.
 * @property prune Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
 * @property retryIntervalInSeconds The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
 * @property syncIntervalInSeconds The interval at which to re-reconcile the Kustomization on the cluster.
 * @property timeoutInSeconds The maximum time to attempt to reconcile the Kustomization on the cluster.
 * @property wait Enable/disable health check for all Kubernetes objects created by this Kustomization.
 */
public data class KustomizationDefinitionArgs(
    public val dependsOn: Output<List<String>>? = null,
    public val force: Output<Boolean>? = null,
    public val path: Output<String>? = null,
    public val postBuild: Output<PostBuildDefinitionArgs>? = null,
    public val prune: Output<Boolean>? = null,
    public val retryIntervalInSeconds: Output<Double>? = null,
    public val syncIntervalInSeconds: Output<Double>? = null,
    public val timeoutInSeconds: Output<Double>? = null,
    public val wait: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.KustomizationDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.KustomizationDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.KustomizationDefinitionArgs.builder()
            .dependsOn(dependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .force(force?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .postBuild(postBuild?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prune(prune?.applyValue({ args0 -> args0 }))
            .retryIntervalInSeconds(retryIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .syncIntervalInSeconds(syncIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .wait_(wait?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KustomizationDefinitionArgs].
 */
@PulumiTagMarker
public class KustomizationDefinitionArgsBuilder internal constructor() {
    private var dependsOn: Output<List<String>>? = null

    private var force: Output<Boolean>? = null

    private var path: Output<String>? = null

    private var postBuild: Output<PostBuildDefinitionArgs>? = null

    private var prune: Output<Boolean>? = null

    private var retryIntervalInSeconds: Output<Double>? = null

    private var syncIntervalInSeconds: Output<Double>? = null

    private var timeoutInSeconds: Output<Double>? = null

    private var wait: Output<Boolean>? = null

    /**
     * @param value Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
     */
    @JvmName("wojtdkyjmkmlcnal")
    public suspend fun dependsOn(`value`: Output<List<String>>) {
        this.dependsOn = value
    }

    @JvmName("ypvsekjmchpkpuux")
    public suspend fun dependsOn(vararg values: Output<String>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
     */
    @JvmName("ufkvfiqbgockpufb")
    public suspend fun dependsOn(values: List<Output<String>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
     */
    @JvmName("usqsniahukonytdi")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value The path in the source reference to reconcile on the cluster.
     */
    @JvmName("lrehkymbdonymxbj")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Used for variable substitution for this Kustomization after kustomize build.
     */
    @JvmName("rptfunpmygujfbwg")
    public suspend fun postBuild(`value`: Output<PostBuildDefinitionArgs>) {
        this.postBuild = value
    }

    /**
     * @param value Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
     */
    @JvmName("aiweklaphpgskvxb")
    public suspend fun prune(`value`: Output<Boolean>) {
        this.prune = value
    }

    /**
     * @param value The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
     */
    @JvmName("jdamxfvkbwvudvyg")
    public suspend fun retryIntervalInSeconds(`value`: Output<Double>) {
        this.retryIntervalInSeconds = value
    }

    /**
     * @param value The interval at which to re-reconcile the Kustomization on the cluster.
     */
    @JvmName("lpntwesgrreqldej")
    public suspend fun syncIntervalInSeconds(`value`: Output<Double>) {
        this.syncIntervalInSeconds = value
    }

    /**
     * @param value The maximum time to attempt to reconcile the Kustomization on the cluster.
     */
    @JvmName("bujixoadrhuegwod")
    public suspend fun timeoutInSeconds(`value`: Output<Double>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Enable/disable health check for all Kubernetes objects created by this Kustomization.
     */
    @JvmName("ckivxskrcrlxymas")
    public suspend fun wait(`value`: Output<Boolean>) {
        this.wait = value
    }

    /**
     * @param value Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
     */
    @JvmName("ixlprdvjobkjmckw")
    public suspend fun dependsOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param values Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
     */
    @JvmName("iwncgkaivppheqas")
    public suspend fun dependsOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
     */
    @JvmName("ldaoniafrfvdvvmo")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value The path in the source reference to reconcile on the cluster.
     */
    @JvmName("grdjivrlkiurfiwl")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Used for variable substitution for this Kustomization after kustomize build.
     */
    @JvmName("ibywrhjialbfyxqu")
    public suspend fun postBuild(`value`: PostBuildDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postBuild = mapped
    }

    /**
     * @param argument Used for variable substitution for this Kustomization after kustomize build.
     */
    @JvmName("hhbwrtrwovkayqey")
    public suspend fun postBuild(argument: suspend PostBuildDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = PostBuildDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.postBuild = mapped
    }

    /**
     * @param value Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
     */
    @JvmName("xbadvuepjapnsuls")
    public suspend fun prune(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prune = mapped
    }

    /**
     * @param value The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
     */
    @JvmName("dsdqtepesulttrlh")
    public suspend fun retryIntervalInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryIntervalInSeconds = mapped
    }

    /**
     * @param value The interval at which to re-reconcile the Kustomization on the cluster.
     */
    @JvmName("wkateumpkgofhtgv")
    public suspend fun syncIntervalInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncIntervalInSeconds = mapped
    }

    /**
     * @param value The maximum time to attempt to reconcile the Kustomization on the cluster.
     */
    @JvmName("pendfafpqgwfdtdr")
    public suspend fun timeoutInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value Enable/disable health check for all Kubernetes objects created by this Kustomization.
     */
    @JvmName("dgmmxcpamxcrumue")
    public suspend fun wait(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wait = mapped
    }

    internal fun build(): KustomizationDefinitionArgs = KustomizationDefinitionArgs(
        dependsOn = dependsOn,
        force = force,
        path = path,
        postBuild = postBuild,
        prune = prune,
        retryIntervalInSeconds = retryIntervalInSeconds,
        syncIntervalInSeconds = syncIntervalInSeconds,
        timeoutInSeconds = timeoutInSeconds,
        wait = wait,
    )
}
