@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies that the scope of the extension is Namespace
 * @property targetNamespace Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
 */
public data class ScopeNamespaceArgs(
    public val targetNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeNamespaceArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeNamespaceArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeNamespaceArgs.builder()
            .targetNamespace(targetNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopeNamespaceArgs].
 */
@PulumiTagMarker
public class ScopeNamespaceArgsBuilder internal constructor() {
    private var targetNamespace: Output<String>? = null

    /**
     * @param value Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
     */
    @JvmName("hbbmwigeuwpeqcnt")
    public suspend fun targetNamespace(`value`: Output<String>) {
        this.targetNamespace = value
    }

    /**
     * @param value Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
     */
    @JvmName("mtjijsrelvceqcbl")
    public suspend fun targetNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNamespace = mapped
    }

    internal fun build(): ScopeNamespaceArgs = ScopeNamespaceArgs(
        targetNamespace = targetNamespace,
    )
}
