@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.SubstituteFromDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
 * @property kind Define whether it is ConfigMap or Secret that holds the variables to be used in substitution.
 * @property name Name of the ConfigMap/Secret that holds the variables to be used in substitution.
 * @property optional Set to True to proceed without ConfigMap/Secret, if it is not present.
 */
public data class SubstituteFromDefinitionArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val optional: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.SubstituteFromDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.SubstituteFromDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.SubstituteFromDefinitionArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .optional(optional?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubstituteFromDefinitionArgs].
 */
@PulumiTagMarker
public class SubstituteFromDefinitionArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var optional: Output<Boolean>? = null

    /**
     * @param value Define whether it is ConfigMap or Secret that holds the variables to be used in substitution.
     */
    @JvmName("sdxbviiwykbutajb")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the ConfigMap/Secret that holds the variables to be used in substitution.
     */
    @JvmName("ygxbwphpyrfmseco")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Set to True to proceed without ConfigMap/Secret, if it is not present.
     */
    @JvmName("cwgtahbovljdgnpg")
    public suspend fun optional(`value`: Output<Boolean>) {
        this.optional = value
    }

    /**
     * @param value Define whether it is ConfigMap or Secret that holds the variables to be used in substitution.
     */
    @JvmName("mdlhirqajsjrafim")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the ConfigMap/Secret that holds the variables to be used in substitution.
     */
    @JvmName("jtlkekknmtvxupyg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Set to True to proceed without ConfigMap/Secret, if it is not present.
     */
    @JvmName("qrihgxjfvtxnsdlf")
    public suspend fun optional(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optional = mapped
    }

    internal fun build(): SubstituteFromDefinitionArgs = SubstituteFromDefinitionArgs(
        kind = kind,
        name = name,
        optional = optional,
    )
}
