@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Parameters to reconcile to the Bucket source kind type.
 * @property accessKey Plaintext access key used to securely access the S3 bucket
 * @property bucketName The bucket name to sync from the url endpoint for the flux configuration.
 * @property insecure Specify whether to use insecure communication when puling data from the S3 bucket.
 * @property localAuthRef Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
 * @property syncIntervalInSeconds The interval at which to re-reconcile the cluster bucket source with the remote.
 * @property timeoutInSeconds The maximum time to attempt to reconcile the cluster bucket source with the remote.
 * @property url The URL to sync for the flux configuration S3 bucket.
 */
public data class BucketDefinitionResponse(
    public val accessKey: String? = null,
    public val bucketName: String? = null,
    public val insecure: Boolean? = null,
    public val localAuthRef: String? = null,
    public val syncIntervalInSeconds: Double? = null,
    public val timeoutInSeconds: Double? = null,
    public val url: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.BucketDefinitionResponse):
            BucketDefinitionResponse = BucketDefinitionResponse(
            accessKey = javaType.accessKey().map({ args0 -> args0 }).orElse(null),
            bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
            insecure = javaType.insecure().map({ args0 -> args0 }).orElse(null),
            localAuthRef = javaType.localAuthRef().map({ args0 -> args0 }).orElse(null),
            syncIntervalInSeconds = javaType.syncIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
