@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Properties for HelmRelease objects
 * @property failureCount Total number of times that the HelmRelease failed to install or upgrade
 * @property helmChartRef The reference to the HelmChart object used as the source to this HelmRelease
 * @property installFailureCount Number of times that the HelmRelease failed to install
 * @property lastRevisionApplied The revision number of the last released object change
 * @property upgradeFailureCount Number of times that the HelmRelease failed to upgrade
 */
public data class HelmReleasePropertiesDefinitionResponse(
    public val failureCount: Double? = null,
    public val helmChartRef: ObjectReferenceDefinitionResponse? = null,
    public val installFailureCount: Double? = null,
    public val lastRevisionApplied: Double? = null,
    public val upgradeFailureCount: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.HelmReleasePropertiesDefinitionResponse):
            HelmReleasePropertiesDefinitionResponse = HelmReleasePropertiesDefinitionResponse(
            failureCount = javaType.failureCount().map({ args0 -> args0 }).orElse(null),
            helmChartRef = javaType.helmChartRef().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ObjectReferenceDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            installFailureCount = javaType.installFailureCount().map({ args0 -> args0 }).orElse(null),
            lastRevisionApplied = javaType.lastRevisionApplied().map({ args0 -> args0 }).orElse(null),
            upgradeFailureCount = javaType.upgradeFailureCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
