@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin

import com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LoadBalancer].
 */
@PulumiTagMarker
public class LoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerArgs = LoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerArgsBuilder.() -> Unit) {
        val builder = LoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancer {
        val builtJavaResource =
            com.pulumi.azurenative.kubernetesruntime.LoadBalancer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoadBalancer(builtJavaResource)
    }
}

/**
 * A LoadBalancer resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### LoadBalancers_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.KubernetesRuntime.LoadBalancer("loadBalancer", new()
 *     {
 *         Addresses = new[]
 *         {
 *             "192.168.50.1/24",
 *             "192.168.51.2-192.168.51.10",
 *         },
 *         AdvertiseMode = AzureNative.KubernetesRuntime.AdvertiseMode.ARP,
 *         LoadBalancerName = "testlb",
 *         ResourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1",
 *         ServiceSelector =
 *         {
 *             { "app", "frontend" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesruntime/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesruntime.NewLoadBalancer(ctx, "loadBalancer", &kubernetesruntime.LoadBalancerArgs{
 * 			Addresses: pulumi.StringArray{
 * 				pulumi.String("192.168.50.1/24"),
 * 				pulumi.String("192.168.51.2-192.168.51.10"),
 * 			},
 * 			AdvertiseMode:    pulumi.String(kubernetesruntime.AdvertiseModeARP),
 * 			LoadBalancerName: pulumi.String("testlb"),
 * 			ResourceUri:      pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1"),
 * 			ServiceSelector: pulumi.StringMap{
 * 				"app": pulumi.String("frontend"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesruntime.LoadBalancer;
 * import com.pulumi.azurenative.kubernetesruntime.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .addresses(
 *                 "192.168.50.1/24",
 *                 "192.168.51.2-192.168.51.10")
 *             .advertiseMode("ARP")
 *             .loadBalancerName("testlb")
 *             .resourceUri("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1")
 *             .serviceSelector(Map.of("app", "frontend"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesruntime:LoadBalancer testlb /{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}
 * ```
 */
public class LoadBalancer internal constructor(
    override val javaResource: com.pulumi.azurenative.kubernetesruntime.LoadBalancer,
) : KotlinCustomResource(javaResource, LoadBalancerMapper) {
    /**
     * IP Range
     */
    public val addresses: Output<List<String>>
        get() = javaResource.addresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Advertise Mode
     */
    public val advertiseMode: Output<String>
        get() = javaResource.advertiseMode().applyValue({ args0 -> args0 })

    /**
     * The list of BGP peers it should advertise to. Null or empty means to advertise to all peers.
     */
    public val bgpPeers: Output<List<String>>?
        get() = javaResource.bgpPeers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource provision state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A dynamic label mapping to select related services. For instance, if you want to create a load balancer only for services with label "a=b", then please specify {"a": "b"} in the field.
     */
    public val serviceSelector: Output<Map<String, String>>?
        get() = javaResource.serviceSelector().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LoadBalancerMapper : ResourceMapper<LoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kubernetesruntime.LoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancer = LoadBalancer(
        javaResource as
            com.pulumi.azurenative.kubernetesruntime.LoadBalancer,
    )
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancer].
 */
public suspend fun loadBalancer(
    name: String,
    block: suspend LoadBalancerResourceBuilder.() -> Unit,
): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancer(name: String): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
