@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin

import com.pulumi.azurenative.kubernetesruntime.LoadBalancerArgs.builder
import com.pulumi.azurenative.kubernetesruntime.kotlin.enums.AdvertiseMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A LoadBalancer resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### LoadBalancers_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.KubernetesRuntime.LoadBalancer("loadBalancer", new()
 *     {
 *         Addresses = new[]
 *         {
 *             "192.168.50.1/24",
 *             "192.168.51.2-192.168.51.10",
 *         },
 *         AdvertiseMode = AzureNative.KubernetesRuntime.AdvertiseMode.ARP,
 *         LoadBalancerName = "testlb",
 *         ResourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1",
 *         ServiceSelector =
 *         {
 *             { "app", "frontend" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesruntime/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesruntime.NewLoadBalancer(ctx, "loadBalancer", &kubernetesruntime.LoadBalancerArgs{
 * 			Addresses: pulumi.StringArray{
 * 				pulumi.String("192.168.50.1/24"),
 * 				pulumi.String("192.168.51.2-192.168.51.10"),
 * 			},
 * 			AdvertiseMode:    pulumi.String(kubernetesruntime.AdvertiseModeARP),
 * 			LoadBalancerName: pulumi.String("testlb"),
 * 			ResourceUri:      pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1"),
 * 			ServiceSelector: pulumi.StringMap{
 * 				"app": pulumi.String("frontend"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesruntime.LoadBalancer;
 * import com.pulumi.azurenative.kubernetesruntime.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .addresses(
 *                 "192.168.50.1/24",
 *                 "192.168.51.2-192.168.51.10")
 *             .advertiseMode("ARP")
 *             .loadBalancerName("testlb")
 *             .resourceUri("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1")
 *             .serviceSelector(Map.of("app", "frontend"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesruntime:LoadBalancer testlb /{resourceUri}/providers/Microsoft.KubernetesRuntime/loadBalancers/{loadBalancerName}
 * ```
 * @property addresses IP Range
 * @property advertiseMode Advertise Mode
 * @property bgpPeers The list of BGP peers it should advertise to. Null or empty means to advertise to all peers.
 * @property loadBalancerName The name of the LoadBalancer
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 * @property serviceSelector A dynamic label mapping to select related services. For instance, if you want to create a load balancer only for services with label "a=b", then please specify {"a": "b"} in the field.
 */
public data class LoadBalancerArgs(
    public val addresses: Output<List<String>>? = null,
    public val advertiseMode: Output<Either<String, AdvertiseMode>>? = null,
    public val bgpPeers: Output<List<String>>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
    public val serviceSelector: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.LoadBalancerArgs =
        com.pulumi.azurenative.kubernetesruntime.LoadBalancerArgs.builder()
            .addresses(addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .advertiseMode(
                advertiseMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .bgpPeers(bgpPeers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .serviceSelector(
                serviceSelector?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var addresses: Output<List<String>>? = null

    private var advertiseMode: Output<Either<String, AdvertiseMode>>? = null

    private var bgpPeers: Output<List<String>>? = null

    private var loadBalancerName: Output<String>? = null

    private var resourceUri: Output<String>? = null

    private var serviceSelector: Output<Map<String, String>>? = null

    /**
     * @param value IP Range
     */
    @JvmName("kabskjxshlhfctna")
    public suspend fun addresses(`value`: Output<List<String>>) {
        this.addresses = value
    }

    @JvmName("ovddlcprtoxdgqhu")
    public suspend fun addresses(vararg values: Output<String>) {
        this.addresses = Output.all(values.asList())
    }

    /**
     * @param values IP Range
     */
    @JvmName("kfkjxskgfauxywmc")
    public suspend fun addresses(values: List<Output<String>>) {
        this.addresses = Output.all(values)
    }

    /**
     * @param value Advertise Mode
     */
    @JvmName("cljiygqpmuuitpdr")
    public suspend fun advertiseMode(`value`: Output<Either<String, AdvertiseMode>>) {
        this.advertiseMode = value
    }

    /**
     * @param value The list of BGP peers it should advertise to. Null or empty means to advertise to all peers.
     */
    @JvmName("gxyyjknefxyrgubl")
    public suspend fun bgpPeers(`value`: Output<List<String>>) {
        this.bgpPeers = value
    }

    @JvmName("kuwwoxfjtdmsujix")
    public suspend fun bgpPeers(vararg values: Output<String>) {
        this.bgpPeers = Output.all(values.asList())
    }

    /**
     * @param values The list of BGP peers it should advertise to. Null or empty means to advertise to all peers.
     */
    @JvmName("hiuibnbaaoyvrqgu")
    public suspend fun bgpPeers(values: List<Output<String>>) {
        this.bgpPeers = Output.all(values)
    }

    /**
     * @param value The name of the LoadBalancer
     */
    @JvmName("wkepxugardmmrsvt")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("shmcrsqjgjlipeqx")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value A dynamic label mapping to select related services. For instance, if you want to create a load balancer only for services with label "a=b", then please specify {"a": "b"} in the field.
     */
    @JvmName("vajopxpfeutboioh")
    public suspend fun serviceSelector(`value`: Output<Map<String, String>>) {
        this.serviceSelector = value
    }

    /**
     * @param value IP Range
     */
    @JvmName("iweqmeyagurdatqy")
    public suspend fun addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param values IP Range
     */
    @JvmName("mfqnorvjlkatdglu")
    public suspend fun addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param value Advertise Mode
     */
    @JvmName("gxnkelaabacahvdf")
    public suspend fun advertiseMode(`value`: Either<String, AdvertiseMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advertiseMode = mapped
    }

    /**
     * @param value Advertise Mode
     */
    @JvmName("dgckxeqnkrfjuohu")
    public fun advertiseMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AdvertiseMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advertiseMode = mapped
    }

    /**
     * @param value Advertise Mode
     */
    @JvmName("dkqvtaqgtmxypelo")
    public fun advertiseMode(`value`: AdvertiseMode) {
        val toBeMapped = Either.ofRight<String, AdvertiseMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advertiseMode = mapped
    }

    /**
     * @param value The list of BGP peers it should advertise to. Null or empty means to advertise to all peers.
     */
    @JvmName("yvuputbdttbiapwt")
    public suspend fun bgpPeers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpPeers = mapped
    }

    /**
     * @param values The list of BGP peers it should advertise to. Null or empty means to advertise to all peers.
     */
    @JvmName("dilfahisjdwhfcrl")
    public suspend fun bgpPeers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bgpPeers = mapped
    }

    /**
     * @param value The name of the LoadBalancer
     */
    @JvmName("eucnmjllihhagnor")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("cpsedhjwnirnrisn")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value A dynamic label mapping to select related services. For instance, if you want to create a load balancer only for services with label "a=b", then please specify {"a": "b"} in the field.
     */
    @JvmName("tukkealntbetrfsn")
    public suspend fun serviceSelector(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceSelector = mapped
    }

    /**
     * @param values A dynamic label mapping to select related services. For instance, if you want to create a load balancer only for services with label "a=b", then please specify {"a": "b"} in the field.
     */
    @JvmName("yeahdouellabcubq")
    public fun serviceSelector(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceSelector = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        addresses = addresses,
        advertiseMode = advertiseMode,
        bgpPeers = bgpPeers,
        loadBalancerName = loadBalancerName,
        resourceUri = resourceUri,
        serviceSelector = serviceSelector,
    )
}
