@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin

import com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [StorageClass].
 */
@PulumiTagMarker
public class StorageClassResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageClassArgs = StorageClassArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageClassArgsBuilder.() -> Unit) {
        val builder = StorageClassArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageClass {
        val builtJavaResource =
            com.pulumi.azurenative.kubernetesruntime.StorageClass(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageClass(builtJavaResource)
    }
}

/**
 * A StorageClass resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### StorageClass_CreateOrUpdate_0
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageClass = new AzureNative.KubernetesRuntime.StorageClass("storageClass", new()
 *     {
 *         ResourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1",
 *         StorageClassName = "testrwx",
 *         TypeProperties = new AzureNative.KubernetesRuntime.Inputs.RwxStorageClassTypePropertiesArgs
 *         {
 *             BackingStorageClassName = "default",
 *             Type = "RWX",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesruntime/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesruntime.NewStorageClass(ctx, "storageClass", &kubernetesruntime.StorageClassArgs{
 * 			ResourceUri:      pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1"),
 * 			StorageClassName: pulumi.String("testrwx"),
 * 			TypeProperties: kubernetesruntime.RwxStorageClassTypeProperties{
 * 				BackingStorageClassName: "default",
 * 				Type:                    "RWX",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesruntime.StorageClass;
 * import com.pulumi.azurenative.kubernetesruntime.StorageClassArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageClass = new StorageClass("storageClass", StorageClassArgs.builder()
 *             .resourceUri("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1")
 *             .storageClassName("testrwx")
 *             .typeProperties(BlobStorageClassTypePropertiesArgs.builder()
 *                 .backingStorageClassName("default")
 *                 .type("RWX")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesruntime:StorageClass testrwx /{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}
 * ```
 */
public class StorageClass internal constructor(
    override val javaResource: com.pulumi.azurenative.kubernetesruntime.StorageClass,
) : KotlinCustomResource(javaResource, StorageClassMapper) {
    /**
     * The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]
     */
    public val accessModes: Output<List<String>>?
        get() = javaResource.accessModes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Volume can be expanded or not
     */
    public val allowVolumeExpansion: Output<String>?
        get() = javaResource.allowVolumeExpansion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Allow single data node failure
     */
    public val dataResilience: Output<String>?
        get() = javaResource.dataResilience().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Failover speed: NA, Slow, Fast
     */
    public val failoverSpeed: Output<String>?
        get() = javaResource.failoverSpeed().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Limitations of the storage class
     */
    public val limitations: Output<List<String>>?
        get() = javaResource.limitations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Additional mount options
     */
    public val mountOptions: Output<List<String>>?
        get() = javaResource.mountOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Performance tier
     */
    public val performance: Output<String>?
        get() = javaResource.performance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Selection priority when multiple storage classes meet the criteria. 0: Highest, -1: Never use
     */
    public val priority: Output<Double>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Provisioner name
     */
    public val provisioner: Output<String>?
        get() = javaResource.provisioner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource provision state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Properties of the StorageClass
     */
    public val typeProperties: Output<Any>
        get() = javaResource.typeProperties().applyValue({ args0 -> args0 })

    /**
     * Binding mode of volumes: Immediate, WaitForFirstConsumer
     */
    public val volumeBindingMode: Output<String>?
        get() = javaResource.volumeBindingMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StorageClassMapper : ResourceMapper<StorageClass> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kubernetesruntime.StorageClass::class == javaResource::class

    override fun map(javaResource: Resource): StorageClass = StorageClass(
        javaResource as
            com.pulumi.azurenative.kubernetesruntime.StorageClass,
    )
}

/**
 * @see [StorageClass].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageClass].
 */
public suspend fun storageClass(
    name: String,
    block: suspend StorageClassResourceBuilder.() -> Unit,
): StorageClass {
    val builder = StorageClassResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageClass].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageClass(name: String): StorageClass {
    val builder = StorageClassResourceBuilder()
    builder.name(name)
    return builder.build()
}
