@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin

import com.pulumi.azurenative.kubernetesruntime.StorageClassArgs.builder
import com.pulumi.azurenative.kubernetesruntime.kotlin.enums.AccessMode
import com.pulumi.azurenative.kubernetesruntime.kotlin.enums.DataResilienceTier
import com.pulumi.azurenative.kubernetesruntime.kotlin.enums.FailoverTier
import com.pulumi.azurenative.kubernetesruntime.kotlin.enums.PerformanceTier
import com.pulumi.azurenative.kubernetesruntime.kotlin.enums.VolumeBindingMode
import com.pulumi.azurenative.kubernetesruntime.kotlin.enums.VolumeExpansion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A StorageClass resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### StorageClass_CreateOrUpdate_0
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageClass = new AzureNative.KubernetesRuntime.StorageClass("storageClass", new()
 *     {
 *         ResourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1",
 *         StorageClassName = "testrwx",
 *         TypeProperties = new AzureNative.KubernetesRuntime.Inputs.RwxStorageClassTypePropertiesArgs
 *         {
 *             BackingStorageClassName = "default",
 *             Type = "RWX",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesruntime/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesruntime.NewStorageClass(ctx, "storageClass", &kubernetesruntime.StorageClassArgs{
 * 			ResourceUri:      pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1"),
 * 			StorageClassName: pulumi.String("testrwx"),
 * 			TypeProperties: kubernetesruntime.RwxStorageClassTypeProperties{
 * 				BackingStorageClassName: "default",
 * 				Type:                    "RWX",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesruntime.StorageClass;
 * import com.pulumi.azurenative.kubernetesruntime.StorageClassArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageClass = new StorageClass("storageClass", StorageClassArgs.builder()
 *             .resourceUri("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1")
 *             .storageClassName("testrwx")
 *             .typeProperties(BlobStorageClassTypePropertiesArgs.builder()
 *                 .backingStorageClassName("default")
 *                 .type("RWX")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesruntime:StorageClass testrwx /{resourceUri}/providers/Microsoft.KubernetesRuntime/storageClasses/{storageClassName}
 * ```
 * @property accessModes The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]
 * @property allowVolumeExpansion Volume can be expanded or not
 * @property dataResilience Allow single data node failure
 * @property failoverSpeed Failover speed: NA, Slow, Fast
 * @property limitations Limitations of the storage class
 * @property mountOptions Additional mount options
 * @property performance Performance tier
 * @property priority Selection priority when multiple storage classes meet the criteria. 0: Highest, -1: Never use
 * @property provisioner Provisioner name
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 * @property storageClassName The name of the the storage class
 * @property typeProperties Properties of the StorageClass
 * @property volumeBindingMode Binding mode of volumes: Immediate, WaitForFirstConsumer
 */
public data class StorageClassArgs(
    public val accessModes: Output<List<Either<String, AccessMode>>>? = null,
    public val allowVolumeExpansion: Output<Either<String, VolumeExpansion>>? = null,
    public val dataResilience: Output<Either<String, DataResilienceTier>>? = null,
    public val failoverSpeed: Output<Either<String, FailoverTier>>? = null,
    public val limitations: Output<List<String>>? = null,
    public val mountOptions: Output<List<String>>? = null,
    public val performance: Output<Either<String, PerformanceTier>>? = null,
    public val priority: Output<Double>? = null,
    public val provisioner: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
    public val storageClassName: Output<String>? = null,
    public val typeProperties: Output<Any>? = null,
    public val volumeBindingMode: Output<Either<String, VolumeBindingMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.StorageClassArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.StorageClassArgs =
        com.pulumi.azurenative.kubernetesruntime.StorageClassArgs.builder()
            .accessModes(
                accessModes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .allowVolumeExpansion(
                allowVolumeExpansion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dataResilience(
                dataResilience?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .failoverSpeed(
                failoverSpeed?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .limitations(limitations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mountOptions(mountOptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .performance(
                performance?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .priority(priority?.applyValue({ args0 -> args0 }))
            .provisioner(provisioner?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .storageClassName(storageClassName?.applyValue({ args0 -> args0 }))
            .typeProperties(typeProperties?.applyValue({ args0 -> args0 }))
            .volumeBindingMode(
                volumeBindingMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [StorageClassArgs].
 */
@PulumiTagMarker
public class StorageClassArgsBuilder internal constructor() {
    private var accessModes: Output<List<Either<String, AccessMode>>>? = null

    private var allowVolumeExpansion: Output<Either<String, VolumeExpansion>>? = null

    private var dataResilience: Output<Either<String, DataResilienceTier>>? = null

    private var failoverSpeed: Output<Either<String, FailoverTier>>? = null

    private var limitations: Output<List<String>>? = null

    private var mountOptions: Output<List<String>>? = null

    private var performance: Output<Either<String, PerformanceTier>>? = null

    private var priority: Output<Double>? = null

    private var provisioner: Output<String>? = null

    private var resourceUri: Output<String>? = null

    private var storageClassName: Output<String>? = null

    private var typeProperties: Output<Any>? = null

    private var volumeBindingMode: Output<Either<String, VolumeBindingMode>>? = null

    /**
     * @param value The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]
     */
    @JvmName("sbqhqroujgysfdod")
    public suspend fun accessModes(`value`: Output<List<Either<String, AccessMode>>>) {
        this.accessModes = value
    }

    @JvmName("oibvvxcdvprvqkxc")
    public suspend fun accessModes(vararg values: Output<Either<String, AccessMode>>) {
        this.accessModes = Output.all(values.asList())
    }

    /**
     * @param values The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]
     */
    @JvmName("aobihaxcgxoxialv")
    public suspend fun accessModes(values: List<Output<Either<String, AccessMode>>>) {
        this.accessModes = Output.all(values)
    }

    /**
     * @param value Volume can be expanded or not
     */
    @JvmName("ylobidnjtiiuecqw")
    public suspend fun allowVolumeExpansion(`value`: Output<Either<String, VolumeExpansion>>) {
        this.allowVolumeExpansion = value
    }

    /**
     * @param value Allow single data node failure
     */
    @JvmName("mmsexvnlpmvdyaqk")
    public suspend fun dataResilience(`value`: Output<Either<String, DataResilienceTier>>) {
        this.dataResilience = value
    }

    /**
     * @param value Failover speed: NA, Slow, Fast
     */
    @JvmName("hhvvdcpegthbyvfl")
    public suspend fun failoverSpeed(`value`: Output<Either<String, FailoverTier>>) {
        this.failoverSpeed = value
    }

    /**
     * @param value Limitations of the storage class
     */
    @JvmName("bvocptpqeqxfhnlg")
    public suspend fun limitations(`value`: Output<List<String>>) {
        this.limitations = value
    }

    @JvmName("qeoyotbludgwfplm")
    public suspend fun limitations(vararg values: Output<String>) {
        this.limitations = Output.all(values.asList())
    }

    /**
     * @param values Limitations of the storage class
     */
    @JvmName("brcajxkjucsvwjma")
    public suspend fun limitations(values: List<Output<String>>) {
        this.limitations = Output.all(values)
    }

    /**
     * @param value Additional mount options
     */
    @JvmName("jpkvmrvllupsjgyt")
    public suspend fun mountOptions(`value`: Output<List<String>>) {
        this.mountOptions = value
    }

    @JvmName("hpaioanosvbxghce")
    public suspend fun mountOptions(vararg values: Output<String>) {
        this.mountOptions = Output.all(values.asList())
    }

    /**
     * @param values Additional mount options
     */
    @JvmName("avovwexaijpvwjop")
    public suspend fun mountOptions(values: List<Output<String>>) {
        this.mountOptions = Output.all(values)
    }

    /**
     * @param value Performance tier
     */
    @JvmName("jcpehscishypxhhi")
    public suspend fun performance(`value`: Output<Either<String, PerformanceTier>>) {
        this.performance = value
    }

    /**
     * @param value Selection priority when multiple storage classes meet the criteria. 0: Highest, -1: Never use
     */
    @JvmName("uyklobinhvcqjqqx")
    public suspend fun priority(`value`: Output<Double>) {
        this.priority = value
    }

    /**
     * @param value Provisioner name
     */
    @JvmName("siujrrefgetsluwy")
    public suspend fun provisioner(`value`: Output<String>) {
        this.provisioner = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("niqjluvluldmnfmd")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The name of the the storage class
     */
    @JvmName("wpqbhghplghqnuei")
    public suspend fun storageClassName(`value`: Output<String>) {
        this.storageClassName = value
    }

    /**
     * @param value Properties of the StorageClass
     */
    @JvmName("rkmcvnlbhfjvawgv")
    public suspend fun typeProperties(`value`: Output<Any>) {
        this.typeProperties = value
    }

    /**
     * @param value Binding mode of volumes: Immediate, WaitForFirstConsumer
     */
    @JvmName("ntcsrankniguerea")
    public suspend fun volumeBindingMode(`value`: Output<Either<String, VolumeBindingMode>>) {
        this.volumeBindingMode = value
    }

    /**
     * @param value The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]
     */
    @JvmName("shkfhkewqpvaqdjk")
    public suspend fun accessModes(`value`: List<Either<String, AccessMode>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessModes = mapped
    }

    /**
     * @param values The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]
     */
    @JvmName("erafbqvgikuxoxjb")
    public suspend fun accessModes(vararg values: Either<String, AccessMode>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessModes = mapped
    }

    /**
     * @param value Volume can be expanded or not
     */
    @JvmName("egjtcogujowjcfro")
    public suspend fun allowVolumeExpansion(`value`: Either<String, VolumeExpansion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVolumeExpansion = mapped
    }

    /**
     * @param value Volume can be expanded or not
     */
    @JvmName("dwovuwmefgdjakng")
    public fun allowVolumeExpansion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VolumeExpansion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowVolumeExpansion = mapped
    }

    /**
     * @param value Volume can be expanded or not
     */
    @JvmName("wsnkdhywcophwybj")
    public fun allowVolumeExpansion(`value`: VolumeExpansion) {
        val toBeMapped = Either.ofRight<String, VolumeExpansion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowVolumeExpansion = mapped
    }

    /**
     * @param value Allow single data node failure
     */
    @JvmName("jftmtgdsblwdxyiw")
    public suspend fun dataResilience(`value`: Either<String, DataResilienceTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataResilience = mapped
    }

    /**
     * @param value Allow single data node failure
     */
    @JvmName("ktxqkvjqpdddcwdr")
    public fun dataResilience(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataResilienceTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataResilience = mapped
    }

    /**
     * @param value Allow single data node failure
     */
    @JvmName("ogcpdbqbwhbwvajk")
    public fun dataResilience(`value`: DataResilienceTier) {
        val toBeMapped = Either.ofRight<String, DataResilienceTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataResilience = mapped
    }

    /**
     * @param value Failover speed: NA, Slow, Fast
     */
    @JvmName("udafskxnjvupepww")
    public suspend fun failoverSpeed(`value`: Either<String, FailoverTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverSpeed = mapped
    }

    /**
     * @param value Failover speed: NA, Slow, Fast
     */
    @JvmName("rguwjtkriehpygak")
    public fun failoverSpeed(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FailoverTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverSpeed = mapped
    }

    /**
     * @param value Failover speed: NA, Slow, Fast
     */
    @JvmName("ythhlmhiiyudopfq")
    public fun failoverSpeed(`value`: FailoverTier) {
        val toBeMapped = Either.ofRight<String, FailoverTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverSpeed = mapped
    }

    /**
     * @param value Limitations of the storage class
     */
    @JvmName("whmquaomatibiugo")
    public suspend fun limitations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitations = mapped
    }

    /**
     * @param values Limitations of the storage class
     */
    @JvmName("jgqfwkfvuxqtlvfw")
    public suspend fun limitations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limitations = mapped
    }

    /**
     * @param value Additional mount options
     */
    @JvmName("dexgowkbnrycvyhs")
    public suspend fun mountOptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param values Additional mount options
     */
    @JvmName("bespvdupygiskjoi")
    public suspend fun mountOptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param value Performance tier
     */
    @JvmName("ivydcfwifkkjsyli")
    public suspend fun performance(`value`: Either<String, PerformanceTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performance = mapped
    }

    /**
     * @param value Performance tier
     */
    @JvmName("cffvhuexkojihpsu")
    public fun performance(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PerformanceTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.performance = mapped
    }

    /**
     * @param value Performance tier
     */
    @JvmName("rbvrpfhkmyumqlcr")
    public fun performance(`value`: PerformanceTier) {
        val toBeMapped = Either.ofRight<String, PerformanceTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.performance = mapped
    }

    /**
     * @param value Selection priority when multiple storage classes meet the criteria. 0: Highest, -1: Never use
     */
    @JvmName("flynpklxhayasutg")
    public suspend fun priority(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Provisioner name
     */
    @JvmName("vpgnuhobwfpsmayu")
    public suspend fun provisioner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioner = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("luvmmldoviiupaxm")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value The name of the the storage class
     */
    @JvmName("jyprtutklaaenwqa")
    public suspend fun storageClassName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClassName = mapped
    }

    /**
     * @param value Properties of the StorageClass
     */
    @JvmName("sikrkqfiucmkklve")
    public suspend fun typeProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeProperties = mapped
    }

    /**
     * @param value Binding mode of volumes: Immediate, WaitForFirstConsumer
     */
    @JvmName("wvgikuvpdxtpcqks")
    public suspend fun volumeBindingMode(`value`: Either<String, VolumeBindingMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeBindingMode = mapped
    }

    /**
     * @param value Binding mode of volumes: Immediate, WaitForFirstConsumer
     */
    @JvmName("xbuquryaguyydggi")
    public fun volumeBindingMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VolumeBindingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeBindingMode = mapped
    }

    /**
     * @param value Binding mode of volumes: Immediate, WaitForFirstConsumer
     */
    @JvmName("gssarlbcavywkyok")
    public fun volumeBindingMode(`value`: VolumeBindingMode) {
        val toBeMapped = Either.ofRight<String, VolumeBindingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeBindingMode = mapped
    }

    internal fun build(): StorageClassArgs = StorageClassArgs(
        accessModes = accessModes,
        allowVolumeExpansion = allowVolumeExpansion,
        dataResilience = dataResilience,
        failoverSpeed = failoverSpeed,
        limitations = limitations,
        mountOptions = mountOptions,
        performance = performance,
        priority = priority,
        provisioner = provisioner,
        resourceUri = resourceUri,
        storageClassName = storageClassName,
        typeProperties = typeProperties,
        volumeBindingMode = volumeBindingMode,
    )
}
