@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Storage Class Access Mode
 */
public enum class AccessMode(
    public val javaValue: com.pulumi.azurenative.kubernetesruntime.enums.AccessMode,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.enums.AccessMode> {
    /**
     * Read Write Once (RWO) access mode
     */
    ReadWriteOnce(com.pulumi.azurenative.kubernetesruntime.enums.AccessMode.ReadWriteOnce),

    /**
     * Read Write Many (RWX) access mode
     */
    ReadWriteMany(com.pulumi.azurenative.kubernetesruntime.enums.AccessMode.ReadWriteMany),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.enums.AccessMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.enums.AccessMode):
            AccessMode = AccessMode.values().first { it.javaValue == javaType }
    }
}
