@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Advertise Mode
 */
public enum class AdvertiseMode(
    public val javaValue: com.pulumi.azurenative.kubernetesruntime.enums.AdvertiseMode,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.enums.AdvertiseMode> {
    /**
     * ARP advertise mode
     */
    ARP(com.pulumi.azurenative.kubernetesruntime.enums.AdvertiseMode.ARP),

    /**
     * BGP advertise mode
     */
    BGP(com.pulumi.azurenative.kubernetesruntime.enums.AdvertiseMode.BGP),

    /**
     * both ARP and BGP advertise mode
     */
    Both(com.pulumi.azurenative.kubernetesruntime.enums.AdvertiseMode.Both),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.enums.AdvertiseMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.enums.AdvertiseMode):
            AdvertiseMode = AdvertiseMode.values().first { it.javaValue == javaType }
    }
}
