@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allow single data node failure
 */
public enum class DataResilienceTier(
    public val javaValue: com.pulumi.azurenative.kubernetesruntime.enums.DataResilienceTier,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.enums.DataResilienceTier> {
    /**
     * Not data resilient
     */
    NotDataResilient(com.pulumi.azurenative.kubernetesruntime.enums.DataResilienceTier.NotDataResilient),

    /**
     * Data resilient
     */
    DataResilient(com.pulumi.azurenative.kubernetesruntime.enums.DataResilienceTier.DataResilient),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.enums.DataResilienceTier =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.enums.DataResilienceTier):
            DataResilienceTier = DataResilienceTier.values().first { it.javaValue == javaType }
    }
}
