@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Performance tier
 */
public enum class PerformanceTier(
    public val javaValue: com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier> {
    /**
     * Undefined Performance Tier
     */
    Undefined(com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier.Undefined),

    /**
     * Basic Performance Tier
     */
    Basic(com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier.Basic),

    /**
     * Standard Performance Tier
     */
    Standard(com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier.Standard),

    /**
     * Premium Performance Tier
     */
    Premium(com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier.Premium),

    /**
     * Ultra Performance Tier
     */
    Ultra(com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier.Ultra),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.enums.PerformanceTier):
            PerformanceTier = PerformanceTier.values().first { it.javaValue == javaType }
    }
}
