@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.GetStorageClassPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 * @property storageClassName The name of the the storage class
 */
public data class GetStorageClassPlainArgs(
    public val resourceUri: String,
    public val storageClassName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.GetStorageClassPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.inputs.GetStorageClassPlainArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.GetStorageClassPlainArgs.builder()
            .resourceUri(resourceUri.let({ args0 -> args0 }))
            .storageClassName(storageClassName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageClassPlainArgs].
 */
@PulumiTagMarker
public class GetStorageClassPlainArgsBuilder internal constructor() {
    private var resourceUri: String? = null

    private var storageClassName: String? = null

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("xcgoffraumoxtals")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    /**
     * @param value The name of the the storage class
     */
    @JvmName("qidcqfdiupvpuvyc")
    public suspend fun storageClassName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageClassName = mapped
    }

    internal fun build(): GetStorageClassPlainArgs = GetStorageClassPlainArgs(
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
        storageClassName = storageClassName ?: throw PulumiNullFieldException("storageClassName"),
    )
}
