@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.NativeStorageClassTypePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of Native StorageClass
 * @property type Type of a storage class
 * Expected value is 'Native'.
 */
public data class NativeStorageClassTypePropertiesArgs(
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.NativeStorageClassTypePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesruntime.inputs.NativeStorageClassTypePropertiesArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.NativeStorageClassTypePropertiesArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NativeStorageClassTypePropertiesArgs].
 */
@PulumiTagMarker
public class NativeStorageClassTypePropertiesArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Type of a storage class
     * Expected value is 'Native'.
     */
    @JvmName("ikdlgynjsgqjqcga")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'Native'.
     */
    @JvmName("dhmuhpydohdgflgt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): NativeStorageClassTypePropertiesArgs = NativeStorageClassTypePropertiesArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
