@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.RwxStorageClassTypePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of RWX StorageClass
 * @property backingStorageClassName The backing storageclass used to create new storageclass
 * @property type Type of a storage class
 * Expected value is 'RWX'.
 */
public data class RwxStorageClassTypePropertiesArgs(
    public val backingStorageClassName: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.RwxStorageClassTypePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesruntime.inputs.RwxStorageClassTypePropertiesArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.RwxStorageClassTypePropertiesArgs.builder()
            .backingStorageClassName(backingStorageClassName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RwxStorageClassTypePropertiesArgs].
 */
@PulumiTagMarker
public class RwxStorageClassTypePropertiesArgsBuilder internal constructor() {
    private var backingStorageClassName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The backing storageclass used to create new storageclass
     */
    @JvmName("nkopjyvjwvfkbfsd")
    public suspend fun backingStorageClassName(`value`: Output<String>) {
        this.backingStorageClassName = value
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'RWX'.
     */
    @JvmName("xsuplaubitskvicw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The backing storageclass used to create new storageclass
     */
    @JvmName("syqorspehguwyrfo")
    public suspend fun backingStorageClassName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backingStorageClassName = mapped
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'RWX'.
     */
    @JvmName("rsjlqppjnhckjygn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RwxStorageClassTypePropertiesArgs = RwxStorageClassTypePropertiesArgs(
        backingStorageClassName = backingStorageClassName ?: throw
            PulumiNullFieldException("backingStorageClassName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
