@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A BgpPeer resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property myAsn My ASN
 * @property name The name of the resource
 * @property peerAddress Peer Address
 * @property peerAsn Peer ASN
 * @property provisioningState Resource provision state
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetBgpPeerResult(
    public val id: String,
    public val myAsn: Int,
    public val name: String,
    public val peerAddress: String,
    public val peerAsn: Int,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.outputs.GetBgpPeerResult):
            GetBgpPeerResult = GetBgpPeerResult(
            id = javaType.id(),
            myAsn = javaType.myAsn(),
            name = javaType.name(),
            peerAddress = javaType.peerAddress(),
            peerAsn = javaType.peerAsn(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
