@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of NFS StorageClass
 * @property mountPermissions Mounted folder permissions. Default is 0. If set as non-zero, driver will perform `chmod` after mount
 * @property onDelete The action to take when a NFS volume is deleted. Default is Delete
 * @property server NFS Server
 * @property share NFS share
 * @property subDir Sub directory under share. If the sub directory doesn't exist, driver will create it
 * @property type Type of a storage class
 * Expected value is 'NFS'.
 */
public data class NfsStorageClassTypePropertiesResponse(
    public val mountPermissions: String? = null,
    public val onDelete: String? = null,
    public val server: String,
    public val share: String,
    public val subDir: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.outputs.NfsStorageClassTypePropertiesResponse):
            NfsStorageClassTypePropertiesResponse = NfsStorageClassTypePropertiesResponse(
            mountPermissions = javaType.mountPermissions().map({ args0 -> args0 }).orElse(null),
            onDelete = javaType.onDelete().map({ args0 -> args0 }).orElse(null),
            server = javaType.server(),
            share = javaType.share(),
            subDir = javaType.subDir().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
