@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.DatabasePrincipalAssignmentArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.DatabasePrincipalRole
import com.pulumi.azurenative.kusto.kotlin.enums.PrincipalType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a database principal assignment.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### KustoDatabasePrincipalAssignmentsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databasePrincipalAssignment = new AzureNative.Kusto.DatabasePrincipalAssignment("databasePrincipalAssignment", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DatabaseName = "Kustodatabase8",
 *         PrincipalAssignmentName = "kustoprincipal1",
 *         PrincipalId = "87654321-1234-1234-1234-123456789123",
 *         PrincipalType = AzureNative.Kusto.PrincipalType.App,
 *         ResourceGroupName = "kustorptest",
 *         Role = AzureNative.Kusto.DatabasePrincipalRole.Admin,
 *         TenantId = "12345678-1234-1234-1234-123456789123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewDatabasePrincipalAssignment(ctx, "databasePrincipalAssignment", &kusto.DatabasePrincipalAssignmentArgs{
 * 			ClusterName:             pulumi.String("kustoCluster"),
 * 			DatabaseName:            pulumi.String("Kustodatabase8"),
 * 			PrincipalAssignmentName: pulumi.String("kustoprincipal1"),
 * 			PrincipalId:             pulumi.String("87654321-1234-1234-1234-123456789123"),
 * 			PrincipalType:           pulumi.String(kusto.PrincipalTypeApp),
 * 			ResourceGroupName:       pulumi.String("kustorptest"),
 * 			Role:                    pulumi.String(kusto.DatabasePrincipalRoleAdmin),
 * 			TenantId:                pulumi.String("12345678-1234-1234-1234-123456789123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.DatabasePrincipalAssignment;
 * import com.pulumi.azurenative.kusto.DatabasePrincipalAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databasePrincipalAssignment = new DatabasePrincipalAssignment("databasePrincipalAssignment", DatabasePrincipalAssignmentArgs.builder()
 *             .clusterName("kustoCluster")
 *             .databaseName("Kustodatabase8")
 *             .principalAssignmentName("kustoprincipal1")
 *             .principalId("87654321-1234-1234-1234-123456789123")
 *             .principalType("App")
 *             .resourceGroupName("kustorptest")
 *             .role("Admin")
 *             .tenantId("12345678-1234-1234-1234-123456789123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:DatabasePrincipalAssignment kustoCluster/Kustodatabase8/kustoprincipal1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/principalAssignments/{principalAssignmentName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property principalAssignmentName The name of the Kusto principalAssignment.
 * @property principalId The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
 * @property principalType Principal type.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property role Database principal role.
 * @property tenantId The tenant id of the principal
 */
public data class DatabasePrincipalAssignmentArgs(
    public val clusterName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val principalAssignmentName: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalType: Output<Either<String, PrincipalType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val role: Output<Either<String, DatabasePrincipalRole>>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.DatabasePrincipalAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.DatabasePrincipalAssignmentArgs =
        com.pulumi.azurenative.kusto.DatabasePrincipalAssignmentArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .principalAssignmentName(principalAssignmentName?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalType(
                principalType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .role(
                role?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabasePrincipalAssignmentArgs].
 */
@PulumiTagMarker
public class DatabasePrincipalAssignmentArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var principalAssignmentName: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalType: Output<Either<String, PrincipalType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var role: Output<Either<String, DatabasePrincipalRole>>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("wipbvufddvojuwfb")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("hahytisikcspnayi")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("sugiqoqcofnanngd")
    public suspend fun principalAssignmentName(`value`: Output<String>) {
        this.principalAssignmentName = value
    }

    /**
     * @param value The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
     */
    @JvmName("fpfcyryowmxqryha")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Principal type.
     */
    @JvmName("civanjbdrfsxsahv")
    public suspend fun principalType(`value`: Output<Either<String, PrincipalType>>) {
        this.principalType = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("cgtxjmwirrmcblwx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Database principal role.
     */
    @JvmName("dtmxvfdmmtgwriuq")
    public suspend fun role(`value`: Output<Either<String, DatabasePrincipalRole>>) {
        this.role = value
    }

    /**
     * @param value The tenant id of the principal
     */
    @JvmName("lagpeytywnqfwdtw")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("giavieqjtwxbbmsh")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("xybmnymxninnfmvj")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("rswxuwqbpjohkpky")
    public suspend fun principalAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalAssignmentName = mapped
    }

    /**
     * @param value The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
     */
    @JvmName("rvfmwlrtgfftsybc")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("anlnclfvfhpdbrkt")
    public suspend fun principalType(`value`: Either<String, PrincipalType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("fcfgfbwaowhbcqap")
    public fun principalType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("aonulfeexysreqcq")
    public fun principalType(`value`: PrincipalType) {
        val toBeMapped = Either.ofRight<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("vkktnyupmfdsmphm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Database principal role.
     */
    @JvmName("vogqgaxykjxkspxk")
    public suspend fun role(`value`: Either<String, DatabasePrincipalRole>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Database principal role.
     */
    @JvmName("ojkhunuhoteeppqo")
    public fun role(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabasePrincipalRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Database principal role.
     */
    @JvmName("jxqxwgqtltykvexc")
    public fun role(`value`: DatabasePrincipalRole) {
        val toBeMapped = Either.ofRight<String, DatabasePrincipalRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The tenant id of the principal
     */
    @JvmName("oxogdbklybhettnb")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): DatabasePrincipalAssignmentArgs = DatabasePrincipalAssignmentArgs(
        clusterName = clusterName,
        databaseName = databaseName,
        principalAssignmentName = principalAssignmentName,
        principalId = principalId,
        principalType = principalType,
        resourceGroupName = resourceGroupName,
        role = role,
        tenantId = tenantId,
    )
}
