@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventGridDataConnection].
 */
@PulumiTagMarker
public class EventGridDataConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventGridDataConnectionArgs = EventGridDataConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventGridDataConnectionArgsBuilder.() -> Unit) {
        val builder = EventGridDataConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventGridDataConnection {
        val builtJavaResource =
            com.pulumi.azurenative.kusto.EventGridDataConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EventGridDataConnection(builtJavaResource)
    }
}

/**
 * Class representing an Event Grid data connection.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### KustoDataConnectionsCosmosDbCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventGridDataConnection = new AzureNative.Kusto.EventGridDataConnection("eventGridDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase1",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventGridDataConnection(ctx, "eventGridDataConnection", &kusto.EventGridDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase1"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventGridDataConnection;
 * import com.pulumi.azurenative.kusto.EventGridDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventGridDataConnection = new EventGridDataConnection("eventGridDataConnection", EventGridDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase1")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventGridDataConnection = new AzureNative.Kusto.EventGridDataConnection("eventGridDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventGridDataConnection(ctx, "eventGridDataConnection", &kusto.EventGridDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventGridDataConnection;
 * import com.pulumi.azurenative.kusto.EventGridDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventGridDataConnection = new EventGridDataConnection("eventGridDataConnection", EventGridDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsEventGridCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventGridDataConnection = new AzureNative.Kusto.EventGridDataConnection("eventGridDataConnection", new()
 *     {
 *         BlobStorageEventType = AzureNative.Kusto.BlobStorageEventType.Microsoft_Storage_BlobCreated,
 *         ClusterName = "kustoCluster",
 *         ConsumerGroup = "$Default",
 *         DataConnectionName = "dataConnectionTest",
 *         DataFormat = AzureNative.Kusto.EventGridDataFormat.JSON,
 *         DatabaseName = "KustoDatabase8",
 *         DatabaseRouting = AzureNative.Kusto.DatabaseRouting.Single,
 *         EventGridResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount/providers/Microsoft.EventGrid/eventSubscriptions/eventSubscriptionTest",
 *         EventHubResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest2",
 *         IgnoreFirstRecord = false,
 *         Kind = "EventGrid",
 *         Location = "westus",
 *         ManagedIdentityResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1",
 *         MappingRuleName = "TestMapping",
 *         ResourceGroupName = "kustorptest",
 *         StorageAccountResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 *         TableName = "TestTable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventGridDataConnection(ctx, "eventGridDataConnection", &kusto.EventGridDataConnectionArgs{
 * 			BlobStorageEventType:      pulumi.String(kusto.BlobStorageEventType_Microsoft_Storage_BlobCreated),
 * 			ClusterName:               pulumi.String("kustoCluster"),
 * 			ConsumerGroup:             pulumi.String("$Default"),
 * 			DataConnectionName:        pulumi.String("dataConnectionTest"),
 * 			DataFormat:                pulumi.String(kusto.EventGridDataFormatJSON),
 * 			DatabaseName:              pulumi.String("KustoDatabase8"),
 * 			DatabaseRouting:           pulumi.String(kusto.DatabaseRoutingSingle),
 * 			EventGridResourceId:       pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount/providers/Microsoft.EventGrid/eventSubscriptions/eventSubscriptionTest"),
 * 			EventHubResourceId:        pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest2"),
 * 			IgnoreFirstRecord:         pulumi.Bool(false),
 * 			Kind:                      pulumi.String("EventGrid"),
 * 			Location:                  pulumi.String("westus"),
 * 			ManagedIdentityResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1"),
 * 			MappingRuleName:           pulumi.String("TestMapping"),
 * 			ResourceGroupName:         pulumi.String("kustorptest"),
 * 			StorageAccountResourceId:  pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount"),
 * 			TableName:                 pulumi.String("TestTable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventGridDataConnection;
 * import com.pulumi.azurenative.kusto.EventGridDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventGridDataConnection = new EventGridDataConnection("eventGridDataConnection", EventGridDataConnectionArgs.builder()
 *             .blobStorageEventType("Microsoft.Storage.BlobCreated")
 *             .clusterName("kustoCluster")
 *             .consumerGroup("$Default")
 *             .dataConnectionName("dataConnectionTest")
 *             .dataFormat("JSON")
 *             .databaseName("KustoDatabase8")
 *             .databaseRouting("Single")
 *             .eventGridResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount/providers/Microsoft.EventGrid/eventSubscriptions/eventSubscriptionTest")
 *             .eventHubResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest2")
 *             .ignoreFirstRecord(false)
 *             .kind("EventGrid")
 *             .location("westus")
 *             .managedIdentityResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1")
 *             .mappingRuleName("TestMapping")
 *             .resourceGroupName("kustorptest")
 *             .storageAccountResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/teststorageaccount")
 *             .tableName("TestTable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:EventGridDataConnection kustoCluster/KustoDatabase8/dataConnectionTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 */
public class EventGridDataConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.EventGridDataConnection,
) : KotlinCustomResource(javaResource, EventGridDataConnectionMapper) {
    /**
     * The name of blob storage event type to process.
     */
    public val blobStorageEventType: Output<String>?
        get() = javaResource.blobStorageEventType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The event hub consumer group.
     */
    public val consumerGroup: Output<String>
        get() = javaResource.consumerGroup().applyValue({ args0 -> args0 })

    /**
     * The data format of the message. Optionally the data format can be added to each message.
     */
    public val dataFormat: Output<String>?
        get() = javaResource.dataFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    public val databaseRouting: Output<String>?
        get() = javaResource.databaseRouting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the event grid that is subscribed to the storage account events.
     */
    public val eventGridResourceId: Output<String>?
        get() = javaResource.eventGridResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID where the event grid is configured to send events.
     */
    public val eventHubResourceId: Output<String>
        get() = javaResource.eventHubResourceId().applyValue({ args0 -> args0 })

    /**
     * A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
     */
    public val ignoreFirstRecord: Output<Boolean>?
        get() = javaResource.ignoreFirstRecord().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of the endpoint for the data connection
     * Expected value is 'EventGrid'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The object ID of managedIdentityResourceId
     */
    public val managedIdentityObjectId: Output<String>
        get() = javaResource.managedIdentityObjectId().applyValue({ args0 -> args0 })

    /**
     * The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub and storage account.
     */
    public val managedIdentityResourceId: Output<String>?
        get() = javaResource.managedIdentityResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    public val mappingRuleName: Output<String>?
        get() = javaResource.mappingRuleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the storage account where the data resides.
     */
    public val storageAccountResourceId: Output<String>
        get() = javaResource.storageAccountResourceId().applyValue({ args0 -> args0 })

    /**
     * The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    public val tableName: Output<String>?
        get() = javaResource.tableName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EventGridDataConnectionMapper : ResourceMapper<EventGridDataConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.EventGridDataConnection::class == javaResource::class

    override fun map(javaResource: Resource): EventGridDataConnection =
        EventGridDataConnection(javaResource as com.pulumi.azurenative.kusto.EventGridDataConnection)
}

/**
 * @see [EventGridDataConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventGridDataConnection].
 */
public suspend fun eventGridDataConnection(
    name: String,
    block: suspend EventGridDataConnectionResourceBuilder.() -> Unit,
): EventGridDataConnection {
    val builder = EventGridDataConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventGridDataConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventGridDataConnection(name: String): EventGridDataConnection {
    val builder = EventGridDataConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
