@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.KustoFunctions.getAttachedDatabaseConfigurationPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getClusterPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getClusterPrincipalAssignmentPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getCosmosDbDataConnectionPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getDatabasePrincipalAssignmentPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getEventGridDataConnectionPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getEventHubConnectionPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getEventHubDataConnectionPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getIotHubDataConnectionPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getManagedPrivateEndpointPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.kusto.KustoFunctions.getReadOnlyFollowingDatabasePlain
import com.pulumi.azurenative.kusto.KustoFunctions.getReadWriteDatabasePlain
import com.pulumi.azurenative.kusto.KustoFunctions.getSandboxCustomImagePlain
import com.pulumi.azurenative.kusto.KustoFunctions.getScriptPlain
import com.pulumi.azurenative.kusto.KustoFunctions.listClusterFollowerDatabasesPlain
import com.pulumi.azurenative.kusto.KustoFunctions.listClusterLanguageExtensionsPlain
import com.pulumi.azurenative.kusto.KustoFunctions.listDatabasePrincipalsPlain
import com.pulumi.azurenative.kusto.kotlin.inputs.GetAttachedDatabaseConfigurationPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetAttachedDatabaseConfigurationPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetClusterPrincipalAssignmentPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetClusterPrincipalAssignmentPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetCosmosDbDataConnectionPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetCosmosDbDataConnectionPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetDatabasePrincipalAssignmentPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetDatabasePrincipalAssignmentPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetEventGridDataConnectionPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetEventGridDataConnectionPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetEventHubConnectionPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetEventHubConnectionPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetEventHubDataConnectionPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetEventHubDataConnectionPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetIotHubDataConnectionPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetIotHubDataConnectionPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetManagedPrivateEndpointPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetManagedPrivateEndpointPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetReadOnlyFollowingDatabasePlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetReadOnlyFollowingDatabasePlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetReadWriteDatabasePlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetReadWriteDatabasePlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetSandboxCustomImagePlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetSandboxCustomImagePlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.GetScriptPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.GetScriptPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.ListClusterFollowerDatabasesPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.ListClusterFollowerDatabasesPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.ListClusterLanguageExtensionsPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.ListClusterLanguageExtensionsPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.ListDatabasePrincipalsPlainArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.ListDatabasePrincipalsPlainArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.outputs.GetAttachedDatabaseConfigurationResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetClusterPrincipalAssignmentResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetCosmosDbDataConnectionResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetDatabasePrincipalAssignmentResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetEventGridDataConnectionResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetEventHubConnectionResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetEventHubDataConnectionResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetIotHubDataConnectionResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetManagedPrivateEndpointResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetReadOnlyFollowingDatabaseResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetReadWriteDatabaseResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetSandboxCustomImageResult
import com.pulumi.azurenative.kusto.kotlin.outputs.GetScriptResult
import com.pulumi.azurenative.kusto.kotlin.outputs.ListClusterFollowerDatabasesResult
import com.pulumi.azurenative.kusto.kotlin.outputs.ListClusterLanguageExtensionsResult
import com.pulumi.azurenative.kusto.kotlin.outputs.ListDatabasePrincipalsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.kusto.kotlin.outputs.GetAttachedDatabaseConfigurationResult.Companion.toKotlin as getAttachedDatabaseConfigurationResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetClusterPrincipalAssignmentResult.Companion.toKotlin as getClusterPrincipalAssignmentResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetCosmosDbDataConnectionResult.Companion.toKotlin as getCosmosDbDataConnectionResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetDatabasePrincipalAssignmentResult.Companion.toKotlin as getDatabasePrincipalAssignmentResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetEventGridDataConnectionResult.Companion.toKotlin as getEventGridDataConnectionResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetEventHubConnectionResult.Companion.toKotlin as getEventHubConnectionResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetEventHubDataConnectionResult.Companion.toKotlin as getEventHubDataConnectionResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetIotHubDataConnectionResult.Companion.toKotlin as getIotHubDataConnectionResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetManagedPrivateEndpointResult.Companion.toKotlin as getManagedPrivateEndpointResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetReadOnlyFollowingDatabaseResult.Companion.toKotlin as getReadOnlyFollowingDatabaseResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetReadWriteDatabaseResult.Companion.toKotlin as getReadWriteDatabaseResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetSandboxCustomImageResult.Companion.toKotlin as getSandboxCustomImageResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.GetScriptResult.Companion.toKotlin as getScriptResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.ListClusterFollowerDatabasesResult.Companion.toKotlin as listClusterFollowerDatabasesResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.ListClusterLanguageExtensionsResult.Companion.toKotlin as listClusterLanguageExtensionsResultToKotlin
import com.pulumi.azurenative.kusto.kotlin.outputs.ListDatabasePrincipalsResult.Companion.toKotlin as listDatabasePrincipalsResultToKotlin

public object KustoFunctions {
    /**
     * Returns an attached database configuration.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2023-05-02, 2023-08-15.
     * @param argument null
     * @return Class representing an attached database configuration.
     */
    public suspend
    fun getAttachedDatabaseConfiguration(argument: GetAttachedDatabaseConfigurationPlainArgs):
        GetAttachedDatabaseConfigurationResult =
        getAttachedDatabaseConfigurationResultToKotlin(getAttachedDatabaseConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getAttachedDatabaseConfiguration].
     * @param attachedDatabaseConfigurationName The name of the attached database configuration.
     * @param clusterName The name of the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing an attached database configuration.
     */
    public suspend fun getAttachedDatabaseConfiguration(
        attachedDatabaseConfigurationName: String,
        clusterName: String,
        resourceGroupName: String,
    ): GetAttachedDatabaseConfigurationResult {
        val argument = GetAttachedDatabaseConfigurationPlainArgs(
            attachedDatabaseConfigurationName = attachedDatabaseConfigurationName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getAttachedDatabaseConfigurationResultToKotlin(getAttachedDatabaseConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttachedDatabaseConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetAttachedDatabaseConfigurationPlainArgs].
     * @return Class representing an attached database configuration.
     */
    public suspend
    fun getAttachedDatabaseConfiguration(argument: suspend GetAttachedDatabaseConfigurationPlainArgsBuilder.() -> Unit):
        GetAttachedDatabaseConfigurationResult {
        val builder = GetAttachedDatabaseConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttachedDatabaseConfigurationResultToKotlin(getAttachedDatabaseConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Kusto cluster.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2022-07-07, 2023-05-02, 2023-08-15.
     * @param argument null
     * @return Class representing a Kusto cluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName The name of the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing a Kusto cluster.
     */
    public suspend fun getCluster(clusterName: String, resourceGroupName: String): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return Class representing a Kusto cluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Kusto cluster principalAssignment.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2023-05-02, 2023-08-15.
     * @param argument null
     * @return Class representing a cluster principal assignment.
     */
    public suspend
    fun getClusterPrincipalAssignment(argument: GetClusterPrincipalAssignmentPlainArgs):
        GetClusterPrincipalAssignmentResult =
        getClusterPrincipalAssignmentResultToKotlin(getClusterPrincipalAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getClusterPrincipalAssignment].
     * @param clusterName The name of the Kusto cluster.
     * @param principalAssignmentName The name of the Kusto principalAssignment.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing a cluster principal assignment.
     */
    public suspend fun getClusterPrincipalAssignment(
        clusterName: String,
        principalAssignmentName: String,
        resourceGroupName: String,
    ): GetClusterPrincipalAssignmentResult {
        val argument = GetClusterPrincipalAssignmentPlainArgs(
            clusterName = clusterName,
            principalAssignmentName = principalAssignmentName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterPrincipalAssignmentResultToKotlin(getClusterPrincipalAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterPrincipalAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetClusterPrincipalAssignmentPlainArgs].
     * @return Class representing a cluster principal assignment.
     */
    public suspend
    fun getClusterPrincipalAssignment(argument: suspend GetClusterPrincipalAssignmentPlainArgsBuilder.() -> Unit):
        GetClusterPrincipalAssignmentResult {
        val builder = GetClusterPrincipalAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterPrincipalAssignmentResultToKotlin(getClusterPrincipalAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a data connection.
     * Azure REST API version: 2022-12-29.
     * @param argument null
     * @return Class representing a CosmosDb data connection.
     */
    public suspend fun getCosmosDbDataConnection(argument: GetCosmosDbDataConnectionPlainArgs):
        GetCosmosDbDataConnectionResult =
        getCosmosDbDataConnectionResultToKotlin(getCosmosDbDataConnectionPlain(argument.toJava()).await())

    /**
     * @see [getCosmosDbDataConnection].
     * @param clusterName The name of the Kusto cluster.
     * @param dataConnectionName The name of the data connection.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing a CosmosDb data connection.
     */
    public suspend fun getCosmosDbDataConnection(
        clusterName: String,
        dataConnectionName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetCosmosDbDataConnectionResult {
        val argument = GetCosmosDbDataConnectionPlainArgs(
            clusterName = clusterName,
            dataConnectionName = dataConnectionName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getCosmosDbDataConnectionResultToKotlin(getCosmosDbDataConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getCosmosDbDataConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetCosmosDbDataConnectionPlainArgs].
     * @return Class representing a CosmosDb data connection.
     */
    public suspend
    fun getCosmosDbDataConnection(argument: suspend GetCosmosDbDataConnectionPlainArgsBuilder.() -> Unit):
        GetCosmosDbDataConnectionResult {
        val builder = GetCosmosDbDataConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCosmosDbDataConnectionResultToKotlin(getCosmosDbDataConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Kusto cluster database principalAssignment.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2023-05-02, 2023-08-15.
     * @param argument null
     * @return Class representing a database principal assignment.
     */
    public suspend
    fun getDatabasePrincipalAssignment(argument: GetDatabasePrincipalAssignmentPlainArgs):
        GetDatabasePrincipalAssignmentResult =
        getDatabasePrincipalAssignmentResultToKotlin(getDatabasePrincipalAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getDatabasePrincipalAssignment].
     * @param clusterName The name of the Kusto cluster.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param principalAssignmentName The name of the Kusto principalAssignment.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing a database principal assignment.
     */
    public suspend fun getDatabasePrincipalAssignment(
        clusterName: String,
        databaseName: String,
        principalAssignmentName: String,
        resourceGroupName: String,
    ): GetDatabasePrincipalAssignmentResult {
        val argument = GetDatabasePrincipalAssignmentPlainArgs(
            clusterName = clusterName,
            databaseName = databaseName,
            principalAssignmentName = principalAssignmentName,
            resourceGroupName = resourceGroupName,
        )
        return getDatabasePrincipalAssignmentResultToKotlin(getDatabasePrincipalAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabasePrincipalAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetDatabasePrincipalAssignmentPlainArgs].
     * @return Class representing a database principal assignment.
     */
    public suspend
    fun getDatabasePrincipalAssignment(argument: suspend GetDatabasePrincipalAssignmentPlainArgsBuilder.() -> Unit):
        GetDatabasePrincipalAssignmentResult {
        val builder = GetDatabasePrincipalAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabasePrincipalAssignmentResultToKotlin(getDatabasePrincipalAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a data connection.
     * Azure REST API version: 2022-12-29.
     * @param argument null
     * @return Class representing an Event Grid data connection.
     */
    public suspend fun getEventGridDataConnection(argument: GetEventGridDataConnectionPlainArgs):
        GetEventGridDataConnectionResult =
        getEventGridDataConnectionResultToKotlin(getEventGridDataConnectionPlain(argument.toJava()).await())

    /**
     * @see [getEventGridDataConnection].
     * @param clusterName The name of the Kusto cluster.
     * @param dataConnectionName The name of the data connection.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing an Event Grid data connection.
     */
    public suspend fun getEventGridDataConnection(
        clusterName: String,
        dataConnectionName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetEventGridDataConnectionResult {
        val argument = GetEventGridDataConnectionPlainArgs(
            clusterName = clusterName,
            dataConnectionName = dataConnectionName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getEventGridDataConnectionResultToKotlin(getEventGridDataConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventGridDataConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetEventGridDataConnectionPlainArgs].
     * @return Class representing an Event Grid data connection.
     */
    public suspend
    fun getEventGridDataConnection(argument: suspend GetEventGridDataConnectionPlainArgsBuilder.() -> Unit):
        GetEventGridDataConnectionResult {
        val builder = GetEventGridDataConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventGridDataConnectionResultToKotlin(getEventGridDataConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns an Event Hub connection.
     * Azure REST API version: 2018-09-07-preview.
     * @param argument null
     * @return Class representing an event hub connection.
     */
    public suspend fun getEventHubConnection(argument: GetEventHubConnectionPlainArgs):
        GetEventHubConnectionResult =
        getEventHubConnectionResultToKotlin(getEventHubConnectionPlain(argument.toJava()).await())

    /**
     * @see [getEventHubConnection].
     * @param clusterName The name of the Kusto cluster.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param eventHubConnectionName The name of the event hub connection.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing an event hub connection.
     */
    public suspend fun getEventHubConnection(
        clusterName: String,
        databaseName: String,
        eventHubConnectionName: String,
        resourceGroupName: String,
    ): GetEventHubConnectionResult {
        val argument = GetEventHubConnectionPlainArgs(
            clusterName = clusterName,
            databaseName = databaseName,
            eventHubConnectionName = eventHubConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getEventHubConnectionResultToKotlin(getEventHubConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventHubConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetEventHubConnectionPlainArgs].
     * @return Class representing an event hub connection.
     */
    public suspend
    fun getEventHubConnection(argument: suspend GetEventHubConnectionPlainArgsBuilder.() -> Unit):
        GetEventHubConnectionResult {
        val builder = GetEventHubConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventHubConnectionResultToKotlin(getEventHubConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a data connection.
     * Azure REST API version: 2022-12-29.
     * @param argument null
     * @return Class representing an event hub data connection.
     */
    public suspend fun getEventHubDataConnection(argument: GetEventHubDataConnectionPlainArgs):
        GetEventHubDataConnectionResult =
        getEventHubDataConnectionResultToKotlin(getEventHubDataConnectionPlain(argument.toJava()).await())

    /**
     * @see [getEventHubDataConnection].
     * @param clusterName The name of the Kusto cluster.
     * @param dataConnectionName The name of the data connection.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing an event hub data connection.
     */
    public suspend fun getEventHubDataConnection(
        clusterName: String,
        dataConnectionName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetEventHubDataConnectionResult {
        val argument = GetEventHubDataConnectionPlainArgs(
            clusterName = clusterName,
            dataConnectionName = dataConnectionName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getEventHubDataConnectionResultToKotlin(getEventHubDataConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventHubDataConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetEventHubDataConnectionPlainArgs].
     * @return Class representing an event hub data connection.
     */
    public suspend
    fun getEventHubDataConnection(argument: suspend GetEventHubDataConnectionPlainArgsBuilder.() -> Unit):
        GetEventHubDataConnectionResult {
        val builder = GetEventHubDataConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventHubDataConnectionResultToKotlin(getEventHubDataConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a data connection.
     * Azure REST API version: 2022-12-29.
     * @param argument null
     * @return Class representing an iot hub data connection.
     */
    public suspend fun getIotHubDataConnection(argument: GetIotHubDataConnectionPlainArgs):
        GetIotHubDataConnectionResult =
        getIotHubDataConnectionResultToKotlin(getIotHubDataConnectionPlain(argument.toJava()).await())

    /**
     * @see [getIotHubDataConnection].
     * @param clusterName The name of the Kusto cluster.
     * @param dataConnectionName The name of the data connection.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing an iot hub data connection.
     */
    public suspend fun getIotHubDataConnection(
        clusterName: String,
        dataConnectionName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetIotHubDataConnectionResult {
        val argument = GetIotHubDataConnectionPlainArgs(
            clusterName = clusterName,
            dataConnectionName = dataConnectionName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getIotHubDataConnectionResultToKotlin(getIotHubDataConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getIotHubDataConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetIotHubDataConnectionPlainArgs].
     * @return Class representing an iot hub data connection.
     */
    public suspend
    fun getIotHubDataConnection(argument: suspend GetIotHubDataConnectionPlainArgsBuilder.() -> Unit):
        GetIotHubDataConnectionResult {
        val builder = GetIotHubDataConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotHubDataConnectionResultToKotlin(getIotHubDataConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a managed private endpoint.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2023-05-02, 2023-08-15.
     * @param argument null
     * @return Class representing a managed private endpoint.
     */
    public suspend fun getManagedPrivateEndpoint(argument: GetManagedPrivateEndpointPlainArgs):
        GetManagedPrivateEndpointResult =
        getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(argument.toJava()).await())

    /**
     * @see [getManagedPrivateEndpoint].
     * @param clusterName The name of the Kusto cluster.
     * @param managedPrivateEndpointName The name of the managed private endpoint.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing a managed private endpoint.
     */
    public suspend fun getManagedPrivateEndpoint(
        clusterName: String,
        managedPrivateEndpointName: String,
        resourceGroupName: String,
    ): GetManagedPrivateEndpointResult {
        val argument = GetManagedPrivateEndpointPlainArgs(
            clusterName = clusterName,
            managedPrivateEndpointName = managedPrivateEndpointName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedPrivateEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetManagedPrivateEndpointPlainArgs].
     * @return Class representing a managed private endpoint.
     */
    public suspend
    fun getManagedPrivateEndpoint(argument: suspend GetManagedPrivateEndpointPlainArgsBuilder.() -> Unit):
        GetManagedPrivateEndpointResult {
        val builder = GetManagedPrivateEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2023-05-02, 2023-08-15.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param clusterName The name of the Kusto cluster.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        clusterName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            clusterName = clusterName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a database.
     * Azure REST API version: 2022-12-29.
     * @param argument null
     * @return Class representing a read only following database.
     */
    public suspend fun getReadOnlyFollowingDatabase(argument: GetReadOnlyFollowingDatabasePlainArgs):
        GetReadOnlyFollowingDatabaseResult =
        getReadOnlyFollowingDatabaseResultToKotlin(getReadOnlyFollowingDatabasePlain(argument.toJava()).await())

    /**
     * @see [getReadOnlyFollowingDatabase].
     * @param clusterName The name of the Kusto cluster.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing a read only following database.
     */
    public suspend fun getReadOnlyFollowingDatabase(
        clusterName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetReadOnlyFollowingDatabaseResult {
        val argument = GetReadOnlyFollowingDatabasePlainArgs(
            clusterName = clusterName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getReadOnlyFollowingDatabaseResultToKotlin(getReadOnlyFollowingDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getReadOnlyFollowingDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetReadOnlyFollowingDatabasePlainArgs].
     * @return Class representing a read only following database.
     */
    public suspend
    fun getReadOnlyFollowingDatabase(argument: suspend GetReadOnlyFollowingDatabasePlainArgsBuilder.() -> Unit):
        GetReadOnlyFollowingDatabaseResult {
        val builder = GetReadOnlyFollowingDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReadOnlyFollowingDatabaseResultToKotlin(getReadOnlyFollowingDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a database.
     * Azure REST API version: 2022-12-29.
     * @param argument null
     * @return Class representing a read write database.
     */
    public suspend fun getReadWriteDatabase(argument: GetReadWriteDatabasePlainArgs):
        GetReadWriteDatabaseResult =
        getReadWriteDatabaseResultToKotlin(getReadWriteDatabasePlain(argument.toJava()).await())

    /**
     * @see [getReadWriteDatabase].
     * @param clusterName The name of the Kusto cluster.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return Class representing a read write database.
     */
    public suspend fun getReadWriteDatabase(
        clusterName: String,
        databaseName: String,
        resourceGroupName: String,
    ): GetReadWriteDatabaseResult {
        val argument = GetReadWriteDatabasePlainArgs(
            clusterName = clusterName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return getReadWriteDatabaseResultToKotlin(getReadWriteDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getReadWriteDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetReadWriteDatabasePlainArgs].
     * @return Class representing a read write database.
     */
    public suspend
    fun getReadWriteDatabase(argument: suspend GetReadWriteDatabasePlainArgsBuilder.() -> Unit):
        GetReadWriteDatabaseResult {
        val builder = GetReadWriteDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReadWriteDatabaseResultToKotlin(getReadWriteDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a sandbox custom image
     * Azure REST API version: 2023-08-15.
     * @param argument null
     * @return Class representing a Kusto sandbox custom image.
     */
    public suspend fun getSandboxCustomImage(argument: GetSandboxCustomImagePlainArgs):
        GetSandboxCustomImageResult =
        getSandboxCustomImageResultToKotlin(getSandboxCustomImagePlain(argument.toJava()).await())

    /**
     * @see [getSandboxCustomImage].
     * @param clusterName The name of the Kusto cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sandboxCustomImageName The name of the sandbox custom image.
     * @return Class representing a Kusto sandbox custom image.
     */
    public suspend fun getSandboxCustomImage(
        clusterName: String,
        resourceGroupName: String,
        sandboxCustomImageName: String,
    ): GetSandboxCustomImageResult {
        val argument = GetSandboxCustomImagePlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
            sandboxCustomImageName = sandboxCustomImageName,
        )
        return getSandboxCustomImageResultToKotlin(getSandboxCustomImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getSandboxCustomImage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetSandboxCustomImagePlainArgs].
     * @return Class representing a Kusto sandbox custom image.
     */
    public suspend
    fun getSandboxCustomImage(argument: suspend GetSandboxCustomImagePlainArgsBuilder.() -> Unit):
        GetSandboxCustomImageResult {
        val builder = GetSandboxCustomImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSandboxCustomImageResultToKotlin(getSandboxCustomImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Kusto cluster database script.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2021-08-27, 2023-05-02, 2023-08-15.
     * @param argument null
     * @return Class representing a database script.
     */
    public suspend fun getScript(argument: GetScriptPlainArgs): GetScriptResult =
        getScriptResultToKotlin(getScriptPlain(argument.toJava()).await())

    /**
     * @see [getScript].
     * @param clusterName The name of the Kusto cluster.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @param scriptName The name of the Kusto database script.
     * @return Class representing a database script.
     */
    public suspend fun getScript(
        clusterName: String,
        databaseName: String,
        resourceGroupName: String,
        scriptName: String,
    ): GetScriptResult {
        val argument = GetScriptPlainArgs(
            clusterName = clusterName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            scriptName = scriptName,
        )
        return getScriptResultToKotlin(getScriptPlain(argument.toJava()).await())
    }

    /**
     * @see [getScript].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;GetScriptPlainArgs].
     * @return Class representing a database script.
     */
    public suspend fun getScript(argument: suspend GetScriptPlainArgsBuilder.() -> Unit):
        GetScriptResult {
        val builder = GetScriptPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScriptResultToKotlin(getScriptPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of databases that are owned by this cluster and were followed by another cluster.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2022-07-07, 2023-05-02, 2023-08-15.
     * @param argument null
     * @return The list Kusto database principals operation response.
     */
    public suspend fun listClusterFollowerDatabases(argument: ListClusterFollowerDatabasesPlainArgs):
        ListClusterFollowerDatabasesResult =
        listClusterFollowerDatabasesResultToKotlin(listClusterFollowerDatabasesPlain(argument.toJava()).await())

    /**
     * @see [listClusterFollowerDatabases].
     * @param clusterName The name of the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return The list Kusto database principals operation response.
     */
    public suspend fun listClusterFollowerDatabases(clusterName: String, resourceGroupName: String):
        ListClusterFollowerDatabasesResult {
        val argument = ListClusterFollowerDatabasesPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return listClusterFollowerDatabasesResultToKotlin(listClusterFollowerDatabasesPlain(argument.toJava()).await())
    }

    /**
     * @see [listClusterFollowerDatabases].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;ListClusterFollowerDatabasesPlainArgs].
     * @return The list Kusto database principals operation response.
     */
    public suspend
    fun listClusterFollowerDatabases(argument: suspend ListClusterFollowerDatabasesPlainArgsBuilder.() -> Unit):
        ListClusterFollowerDatabasesResult {
        val builder = ListClusterFollowerDatabasesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listClusterFollowerDatabasesResultToKotlin(listClusterFollowerDatabasesPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of language extensions that can run within KQL queries.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2022-07-07, 2023-05-02, 2023-08-15.
     * @param argument null
     * @return The list of language extension objects.
     */
    public suspend
    fun listClusterLanguageExtensions(argument: ListClusterLanguageExtensionsPlainArgs):
        ListClusterLanguageExtensionsResult =
        listClusterLanguageExtensionsResultToKotlin(listClusterLanguageExtensionsPlain(argument.toJava()).await())

    /**
     * @see [listClusterLanguageExtensions].
     * @param clusterName The name of the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return The list of language extension objects.
     */
    public suspend fun listClusterLanguageExtensions(clusterName: String, resourceGroupName: String):
        ListClusterLanguageExtensionsResult {
        val argument = ListClusterLanguageExtensionsPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return listClusterLanguageExtensionsResultToKotlin(listClusterLanguageExtensionsPlain(argument.toJava()).await())
    }

    /**
     * @see [listClusterLanguageExtensions].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;ListClusterLanguageExtensionsPlainArgs].
     * @return The list of language extension objects.
     */
    public suspend
    fun listClusterLanguageExtensions(argument: suspend ListClusterLanguageExtensionsPlainArgsBuilder.() -> Unit):
        ListClusterLanguageExtensionsResult {
        val builder = ListClusterLanguageExtensionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listClusterLanguageExtensionsResultToKotlin(listClusterLanguageExtensionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of database principals of the given Kusto cluster and database.
     * Azure REST API version: 2022-12-29.
     * Other available API versions: 2022-07-07, 2023-05-02, 2023-08-15.
     * @param argument null
     * @return The list Kusto database principals operation response.
     */
    public suspend fun listDatabasePrincipals(argument: ListDatabasePrincipalsPlainArgs):
        ListDatabasePrincipalsResult =
        listDatabasePrincipalsResultToKotlin(listDatabasePrincipalsPlain(argument.toJava()).await())

    /**
     * @see [listDatabasePrincipals].
     * @param clusterName The name of the Kusto cluster.
     * @param databaseName The name of the database in the Kusto cluster.
     * @param resourceGroupName The name of the resource group containing the Kusto cluster.
     * @return The list Kusto database principals operation response.
     */
    public suspend fun listDatabasePrincipals(
        clusterName: String,
        databaseName: String,
        resourceGroupName: String,
    ): ListDatabasePrincipalsResult {
        val argument = ListDatabasePrincipalsPlainArgs(
            clusterName = clusterName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
        )
        return listDatabasePrincipalsResultToKotlin(listDatabasePrincipalsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDatabasePrincipals].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;kusto&#46;kotlin&#46;inputs&#46;ListDatabasePrincipalsPlainArgs].
     * @return The list Kusto database principals operation response.
     */
    public suspend
    fun listDatabasePrincipals(argument: suspend ListDatabasePrincipalsPlainArgsBuilder.() -> Unit):
        ListDatabasePrincipalsResult {
        val builder = ListDatabasePrincipalsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDatabasePrincipalsResultToKotlin(listDatabasePrincipalsPlain(builtArgument.toJava()).await())
    }
}
