@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SandboxCustomImage].
 */
@PulumiTagMarker
public class SandboxCustomImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SandboxCustomImageArgs = SandboxCustomImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SandboxCustomImageArgsBuilder.() -> Unit) {
        val builder = SandboxCustomImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SandboxCustomImage {
        val builtJavaResource = com.pulumi.azurenative.kusto.SandboxCustomImage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SandboxCustomImage(builtJavaResource)
    }
}

/**
 * Class representing a Kusto sandbox custom image.
 * Azure REST API version: 2023-08-15.
 * ## Example Usage
 * ### KustoSandboxCustomImagesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sandboxCustomImage = new AzureNative.Kusto.SandboxCustomImage("sandboxCustomImage", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         Language = AzureNative.Kusto.Language.Python,
 *         LanguageVersion = "3.10.8",
 *         RequirementsFileContent = "Requests",
 *         ResourceGroupName = "kustorptest",
 *         SandboxCustomImageName = "customImage8",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewSandboxCustomImage(ctx, "sandboxCustomImage", &kusto.SandboxCustomImageArgs{
 * 			ClusterName:             pulumi.String("kustoCluster"),
 * 			Language:                pulumi.String(kusto.LanguagePython),
 * 			LanguageVersion:         pulumi.String("3.10.8"),
 * 			RequirementsFileContent: pulumi.String("Requests"),
 * 			ResourceGroupName:       pulumi.String("kustorptest"),
 * 			SandboxCustomImageName:  pulumi.String("customImage8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.SandboxCustomImage;
 * import com.pulumi.azurenative.kusto.SandboxCustomImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sandboxCustomImage = new SandboxCustomImage("sandboxCustomImage", SandboxCustomImageArgs.builder()
 *             .clusterName("kustoCluster")
 *             .language("Python")
 *             .languageVersion("3.10.8")
 *             .requirementsFileContent("Requests")
 *             .resourceGroupName("kustorptest")
 *             .sandboxCustomImageName("customImage8")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:SandboxCustomImage kustoCluster/customImage8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/sandboxCustomImages/{sandboxCustomImageName}
 * ```
 */
public class SandboxCustomImage internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.SandboxCustomImage,
) : KotlinCustomResource(javaResource, SandboxCustomImageMapper) {
    /**
     * The language name, for example Python.
     */
    public val language: Output<String>
        get() = javaResource.language().applyValue({ args0 -> args0 })

    /**
     * The version of the language.
     */
    public val languageVersion: Output<String>
        get() = javaResource.languageVersion().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The requirements file content.
     */
    public val requirementsFileContent: Output<String>?
        get() = javaResource.requirementsFileContent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SandboxCustomImageMapper : ResourceMapper<SandboxCustomImage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.SandboxCustomImage::class == javaResource::class

    override fun map(javaResource: Resource): SandboxCustomImage = SandboxCustomImage(
        javaResource as
            com.pulumi.azurenative.kusto.SandboxCustomImage,
    )
}

/**
 * @see [SandboxCustomImage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SandboxCustomImage].
 */
public suspend fun sandboxCustomImage(
    name: String,
    block: suspend SandboxCustomImageResourceBuilder.() -> Unit,
): SandboxCustomImage {
    val builder = SandboxCustomImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SandboxCustomImage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sandboxCustomImage(name: String): SandboxCustomImage {
    val builder = SandboxCustomImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
